/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxRenameFxIdFieldProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameFxIdFieldProcessor", "canProcessElement"));
        }
        NestedControllerCandidate nestedControllerCandidate = JavaFxRenameFxIdFieldProcessor.findNestedControllerCandidate(element);
        Collection<PsiFile> fxmls = JavaFxRenameFxIdFieldProcessor.findFxmlWithController(nestedControllerCandidate);
        return !fxmls.isEmpty();
    }

    public boolean isInplaceRenameSupported() {
        return false;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
        final NestedControllerCandidate nestedControllerCandidate = JavaFxRenameFxIdFieldProcessor.findNestedControllerCandidate(element);
        if (nestedControllerCandidate != null) {
            Collection<PsiFile> fxmls = JavaFxRenameFxIdFieldProcessor.findFxmlWithController(nestedControllerCandidate);
            for (PsiFile fxml : fxmls) {
                final Ref found = new Ref((Object)false);
                fxml.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        if (((Boolean)found.get()).booleanValue()) {
                            return;
                        }
                        if ("fx:include".equals(tag.getName())) {
                            String value = tag.getAttributeValue("fx:id");
                            if (StringUtil.equals((CharSequence)nestedControllerCandidate.fxId, (CharSequence)value)) {
                                found.set((Object)true);
                            }
                        }
                    }
                });
                if (!((Boolean)found.get()).booleanValue()) continue;
                allRenames.put((PsiElement)nestedControllerCandidate.nestedControllerField, newName + "Controller");
                return;
            }
        }
    }

    @Nullable
    private static NestedControllerCandidate findNestedControllerCandidate(@NotNull PsiElement element) {
        PsiType psiType;
        PsiField nestedControllerField;
        PsiClass containingClass;
        PsiField field;
        String fxId;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameFxIdFieldProcessor", "findNestedControllerCandidate"));
        }
        if (element instanceof PsiField && !StringUtil.isEmpty((String)(fxId = (field = (PsiField)element).getName())) && (containingClass = field.getContainingClass()) != null && (nestedControllerField = containingClass.findFieldByName(fxId + "Controller", true)) != null && !((psiType = nestedControllerField.getType()) instanceof PsiPrimitiveType) && !(psiType instanceof PsiArrayType)) {
            return new NestedControllerCandidate(fxId, nestedControllerField, containingClass);
        }
        return null;
    }

    @NotNull
    private static Collection<PsiFile> findFxmlWithController(@Nullable NestedControllerCandidate nestedControllerCandidate) {
        String qualifiedName;
        if (nestedControllerCandidate != null && (qualifiedName = nestedControllerCandidate.controllerClass.getQualifiedName()) != null) {
            Project project = nestedControllerCandidate.controllerClass.getProject();
            List<PsiFile> list = JavaFxControllerClassIndex.findFxmlWithController(project, qualifiedName);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameFxIdFieldProcessor", "findFxmlWithController"));
            }
            return list;
        }
        List<PsiFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameFxIdFieldProcessor", "findFxmlWithController"));
        }
        return list;
    }

    private static class NestedControllerCandidate {
        private final String fxId;
        private final PsiField nestedControllerField;
        private final PsiClass controllerClass;

        private NestedControllerCandidate(@NotNull String fxId, @NotNull PsiField nestedControllerField, @NotNull PsiClass controllerClass) {
            if (fxId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fxId", "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameFxIdFieldProcessor$NestedControllerCandidate", "<init>"));
            }
            if (nestedControllerField == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nestedControllerField", "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameFxIdFieldProcessor$NestedControllerCandidate", "<init>"));
            }
            if (controllerClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controllerClass", "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameFxIdFieldProcessor$NestedControllerCandidate", "<init>"));
            }
            this.fxId = fxId;
            this.nestedControllerField = nestedControllerField;
            this.controllerClass = controllerClass;
        }
    }
}

