/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.Where;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.Intersection;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;

public class ShelveLocalChangesTask
extends BaseMergeTask {
    @NotNull
    private final Intersection myIntersection;

    public ShelveLocalChangesTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction, @NotNull Intersection intersection) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/ShelveLocalChangesTask", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/ShelveLocalChangesTask", "<init>"));
        }
        if (intersection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intersection", "org/jetbrains/idea/svn/integrate/ShelveLocalChangesTask", "<init>"));
        }
        super(mergeContext, interaction, "Shelving local changes before merge", Where.POOLED);
        this.myIntersection = intersection;
    }

    public void run(final ContinuationContext context) {
        List<VirtualFile> changedFiles = this.shelveChanges(context);
        context.suspend();
        RefreshQueue.getInstance().refresh(true, false, new Runnable(){

            @Override
            public void run() {
                context.ping();
            }
        }, changedFiles);
    }

    @NotNull
    private List<VirtualFile> shelveChanges(@NotNull ContinuationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/integrate/ShelveLocalChangesTask", "shelveChanges"));
        }
        ArrayList changedFiles = ContainerUtil.newArrayList();
        ShelveChangesManager shelveManager = ShelveChangesManager.getInstance((Project)this.myMergeContext.getProject());
        for (Map.Entry entry : this.myIntersection.getChangesSubset().entrySet()) {
            try {
                ShelveLocalChangesTask.saveAllDocuments();
                shelveManager.shelveChanges((Collection)entry.getValue(), this.myIntersection.getComment((String)entry.getKey()) + " (auto shelve before merge)", true, true);
                changedFiles.addAll(ChangesUtil.getAfterRevisionsFiles(((Collection)entry.getValue()).stream(), (boolean)true).collect(Collectors.toList()));
            }
            catch (IOException e) {
                this.finishWithError(context, e.getMessage(), true);
            }
            catch (VcsException e) {
                this.finishWithError(context, e.getMessage(), true);
            }
        }
        ArrayList arrayList = changedFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/ShelveLocalChangesTask", "shelveChanges"));
        }
        return arrayList;
    }

    private static void saveAllDocuments() {
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        }, ModalityState.NON_MODAL);
    }
}

