/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet.ui;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.jps.model.ManifestGenerationMode;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.settings.ProjectSettings;

public class OsmorcFacetGeneralEditorTab
extends FacetEditorTab {
    static final Key<Boolean> MANUAL_MANIFEST_EDITING_KEY = Key.create((String)"MANUAL_MANIFEST_EDITING");
    static final Key<Boolean> BND_CREATION_KEY = Key.create((String)"BND_CREATION");
    static final Key<Boolean> BUNDLOR_CREATION_KEY = Key.create((String)"BUNDLOR_CREATION");
    private JRadioButton myManuallyEditedRadioButton;
    private JRadioButton myControlledByOsmorcRadioButton;
    private TextFieldWithBrowseButton myManifestFileChooser;
    private JPanel myRoot;
    private JRadioButton myUseProjectDefaultManifestFileLocation;
    private JRadioButton myUseModuleSpecificManifestFileLocation;
    private JRadioButton myUseBndFileRadioButton;
    private JPanel myManifestPanel;
    private TextFieldWithBrowseButton myBndFile;
    private JPanel myBndPanel;
    private JRadioButton myUseBundlorFileRadioButton;
    private TextFieldWithBrowseButton myBundlorFile;
    private JPanel myBundlorPanel;
    private JCheckBox myDoNotSynchronizeFacetCheckBox;
    private final FacetEditorContext myEditorContext;
    private final FacetValidatorsManager myValidatorsManager;
    private final Module myModule;
    private boolean myModified;

    public OsmorcFacetGeneralEditorTab(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        this.myEditorContext = editorContext;
        this.myValidatorsManager = validatorsManager;
        this.$$$setupUI$$$();
        this.myModule = editorContext.getModule();
        this.myManifestFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsmorcFacetGeneralEditorTab.this.chooseFile(OsmorcFacetGeneralEditorTab.this.myManifestFileChooser);
            }
        });
        this.myBndFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsmorcFacetGeneralEditorTab.this.chooseFile(OsmorcFacetGeneralEditorTab.this.myBndFile);
            }
        });
        this.myBundlorFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsmorcFacetGeneralEditorTab.this.chooseFile(OsmorcFacetGeneralEditorTab.this.myBundlorFile);
            }
        });
        this.myUseProjectDefaultManifestFileLocation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OsmorcFacetGeneralEditorTab.this.manifestFileLocationSelectorChanged();
            }
        });
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                OsmorcFacetGeneralEditorTab.this.myModified = true;
                OsmorcFacetGeneralEditorTab.this.updateGui();
            }
        });
        watcher.register((Component)this.myRoot);
        this.myValidatorsManager.registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                String location;
                if (OsmorcFacetGeneralEditorTab.this.myManuallyEditedRadioButton.isSelected()) {
                    String string = location = OsmorcFacetGeneralEditorTab.this.myUseModuleSpecificManifestFileLocation.isSelected() ? OsmorcFacetGeneralEditorTab.this.myManifestFileChooser.getText() : ProjectSettings.getInstance(OsmorcFacetGeneralEditorTab.this.myModule.getProject()).getDefaultManifestFileLocation();
                    if (OsmorcFacetGeneralEditorTab.findFileInContentRoots(location, OsmorcFacetGeneralEditorTab.this.myModule) == null) {
                        ValidationResult validationResult = new ValidationResult("No manifest file '" + location + "' found in module");
                        if (validationResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/OsmorcFacetGeneralEditorTab$6", "check"));
                        }
                        return validationResult;
                    }
                }
                if (OsmorcFacetGeneralEditorTab.this.myUseBndFileRadioButton.isSelected() && OsmorcFacetGeneralEditorTab.findFileInContentRoots(location = OsmorcFacetGeneralEditorTab.this.myBndFile.getText(), OsmorcFacetGeneralEditorTab.this.myModule) == null) {
                    ValidationResult validationResult = new ValidationResult("No Bnd file '" + location + "' found in module");
                    if (validationResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/OsmorcFacetGeneralEditorTab$6", "check"));
                    }
                    return validationResult;
                }
                if (OsmorcFacetGeneralEditorTab.this.myUseBundlorFileRadioButton.isSelected() && OsmorcFacetGeneralEditorTab.findFileInContentRoots(location = OsmorcFacetGeneralEditorTab.this.myBundlorFile.getText(), OsmorcFacetGeneralEditorTab.this.myModule) == null) {
                    ValidationResult validationResult = new ValidationResult("No Bundlor file '" + location + "' found in module");
                    if (validationResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/OsmorcFacetGeneralEditorTab$6", "check"));
                    }
                    return validationResult;
                }
                ValidationResult validationResult = ValidationResult.OK;
                if (validationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/OsmorcFacetGeneralEditorTab$6", "check"));
                }
                return validationResult;
            }
        }, new JComponent[0]);
    }

    private void updateGui() {
        boolean isBnd = this.myUseBndFileRadioButton.isSelected();
        boolean isBundlor = this.myUseBundlorFileRadioButton.isSelected();
        boolean isManuallyEdited = this.myManuallyEditedRadioButton.isSelected();
        this.myEditorContext.putUserData(MANUAL_MANIFEST_EDITING_KEY, (Object)isManuallyEdited);
        this.myEditorContext.putUserData(BND_CREATION_KEY, (Object)isBnd);
        this.myEditorContext.putUserData(BUNDLOR_CREATION_KEY, (Object)isBundlor);
        this.myBndPanel.setEnabled(isBnd);
        this.myBundlorPanel.setEnabled(isBundlor);
        this.myManifestPanel.setEnabled(isManuallyEdited);
        this.myUseProjectDefaultManifestFileLocation.setEnabled(isManuallyEdited);
        this.myUseModuleSpecificManifestFileLocation.setEnabled(isManuallyEdited);
        this.myManifestFileChooser.setEnabled(isManuallyEdited && !this.myUseProjectDefaultManifestFileLocation.isSelected());
        this.myBndFile.setEnabled(isBnd);
        this.myBundlorFile.setEnabled(isBundlor);
        this.myValidatorsManager.validate();
    }

    private void chooseFile(TextFieldWithBrowseButton field) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        VirtualFile toSelect = OsmorcFacetGeneralEditorTab.findFileInContentRoots(field.getText(), this.myModule);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.myEditorContext.getProject(), (VirtualFile)toSelect);
        if (file != null) {
            for (VirtualFile root : OsmorcFacetGeneralEditorTab.getContentRoots(this.myModule)) {
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
                if (relativePath == null) continue;
                if (field == this.myManifestFileChooser && file.isDirectory()) {
                    relativePath = relativePath + "/MANIFEST.MF";
                }
                field.setText(relativePath);
                break;
            }
        }
    }

    private void manifestFileLocationSelectorChanged() {
        this.myManifestFileChooser.setEnabled(!this.myUseProjectDefaultManifestFileLocation.isSelected());
        this.myModified = true;
    }

    @Nls
    public String getDisplayName() {
        return "General";
    }

    public String getHelpTopic() {
        return "reference.settings.module.facet.osgi";
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myRoot;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/OsmorcFacetGeneralEditorTab", "createComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() throws ConfigurationException {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this.myEditorContext.getFacet().getConfiguration();
        configuration.setManifestGenerationMode(this.myControlledByOsmorcRadioButton.isSelected() ? ManifestGenerationMode.OsmorcControlled : (this.myUseBndFileRadioButton.isSelected() ? ManifestGenerationMode.Bnd : (this.myUseBundlorFileRadioButton.isSelected() ? ManifestGenerationMode.Bundlor : ManifestGenerationMode.Manually)));
        configuration.setManifestLocation(FileUtil.toSystemIndependentName((String)this.myManifestFileChooser.getText()));
        configuration.setUseProjectDefaultManifestFileLocation(this.myUseProjectDefaultManifestFileLocation.isSelected());
        configuration.setBndFileLocation(FileUtil.toSystemIndependentName((String)this.myBndFile.getText()));
        configuration.setBundlorFileLocation(FileUtil.toSystemIndependentName((String)this.myBundlorFile.getText()));
        configuration.setDoNotSynchronizeWithMaven(this.myDoNotSynchronizeFacetCheckBox.isSelected());
        this.myModified = false;
    }

    public void reset() {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this.myEditorContext.getFacet().getConfiguration();
        if (configuration.isUseBndFile()) {
            this.myUseBndFileRadioButton.setSelected(true);
        } else if (configuration.isUseBundlorFile()) {
            this.myUseBundlorFileRadioButton.setSelected(true);
        } else if (configuration.isOsmorcControlsManifest()) {
            this.myControlledByOsmorcRadioButton.setSelected(true);
        } else {
            this.myManuallyEditedRadioButton.setSelected(true);
        }
        this.myManifestFileChooser.setText(FileUtil.toSystemDependentName((String)configuration.getManifestLocation()));
        if (configuration.isUseProjectDefaultManifestFileLocation()) {
            this.myUseProjectDefaultManifestFileLocation.setSelected(true);
        } else {
            this.myUseModuleSpecificManifestFileLocation.setSelected(true);
        }
        this.myBndFile.setText(FileUtil.toSystemDependentName((String)configuration.getBndFileLocation()));
        this.myBundlorFile.setText(FileUtil.toSystemDependentName((String)configuration.getBundlorFileLocation()));
        this.myDoNotSynchronizeFacetCheckBox.setSelected(configuration.isDoNotSynchronizeWithMaven());
        this.updateGui();
        this.myModified = false;
    }

    public void onTabEntering() {
        this.updateGui();
    }

    public void disposeUIResources() {
    }

    private static VirtualFile[] getContentRoots(Module module) {
        return ModuleRootManager.getInstance((Module)module).getContentRoots();
    }

    private static VirtualFile findFileInContentRoots(String fileName, Module module) {
        for (VirtualFile root : OsmorcFacetGeneralEditorTab.getContentRoots(module)) {
            VirtualFile file = root.findFileByRelativePath(fileName);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel2;
        JRadioButton jRadioButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel3;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel4;
        this.myRoot = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Bundle Creation", (int)0, (int)0, null, null));
        this.myControlledByOsmorcRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Create manifest from facet settings and bundle using facet configuration");
        jPanel5.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myManuallyEditedRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setSelected(true);
        jRadioButton5.setText("Use existing manifest and bundle using facet configuration");
        jPanel5.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myManifestPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3, true));
        this.myUseProjectDefaultManifestFileLocation = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        jRadioButton4.setText("Use project default");
        jPanel3.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myUseModuleSpecificManifestFileLocation = jRadioButton3 = new JRadioButton();
        jRadioButton3.setHorizontalAlignment(10);
        jRadioButton3.setText("Custom:");
        jPanel6.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myManifestFileChooser = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton3.setEnabled(false);
        jPanel6.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(0, 0, 2, 1, 1, 1, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Manifest file location:");
        jPanel7.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("(relative to module root)");
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jPanel7.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseBndFileRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Use Bnd and ignore facet configuration");
        jPanel5.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBndPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3, true));
        this.myBndFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Bnd file location:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myUseBundlorFileRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use Bundlor and ignore facet configuration");
        jPanel5.add((Component)jRadioButton, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBundlorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3, true));
        this.myBundlorFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Bundlor file location:");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Maven Synchronization", (int)0, (int)0, null, null));
        this.myDoNotSynchronizeFacetCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Do not synchronize facet settings with Maven");
        jPanel8.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

