/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.jps.model.OutputPathType;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.ProjectSettings;
import org.osmorc.util.OsgiUiUtil;

public class ProjectSettingsEditorComponent {
    private UserActivityWatcher myWatcher;
    private JPanel myMainPanel;
    private JComboBox<FrameworkInstanceDefinition> myFrameworkInstance;
    private ComboBox<String> myDefaultManifestFileLocation;
    private TextFieldWithBrowseButton myBundleOutputPath;
    private JButton myApplyToAllButton;
    private JBCheckBox myBndAutoImport;
    private Project myProject;
    private ProjectSettings mySettings;
    private boolean myModified;

    public ProjectSettingsEditorComponent(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myFrameworkInstance.setRenderer((ListCellRenderer<FrameworkInstanceDefinition>)((Object)new OsgiUiUtil.FrameworkInstanceRenderer("[not specified]"){

            @Override
            protected boolean isInstanceDefined(@NotNull FrameworkInstanceDefinition instance) {
                if (instance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/osmorc/settings/ProjectSettingsEditorComponent$1", "isInstanceDefined"));
                }
                return Stream.of(ApplicationSettings.getInstance().getActiveFrameworkInstanceDefinitions()).anyMatch(instance::equals);
            }
        }));
        this.myWatcher = new UserActivityWatcher();
        this.myWatcher.register((Component)this.myMainPanel);
        this.myWatcher.addUserActivityListener(() -> {
            this.myModified = true;
        });
        this.myDefaultManifestFileLocation.setEditable(true);
        this.myDefaultManifestFileLocation.addItem((Object)"META-INF");
        this.myBundleOutputPath.addActionListener(e -> {
            VirtualFile virtualFile;
            VirtualFile preselect = LocalFileSystem.getInstance().findFileByPath(this.myBundleOutputPath.getText());
            if (preselect == null) {
                preselect = this.myProject.getBaseDir();
            }
            if ((virtualFile = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)this.myProject, (VirtualFile)preselect)) != null) {
                this.myBundleOutputPath.setText(virtualFile.getPath());
            }
        });
        this.myApplyToAllButton.addActionListener(e -> {
            WriteAction.run(() -> {
                for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                    OsmorcFacet facet = OsmorcFacet.getInstance(module);
                    if (facet == null) continue;
                    OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)facet.getConfiguration();
                    configuration.setJarFileLocation(configuration.getJarFileName(), OutputPathType.OsgiOutputPath);
                }
            });
            String message = "The output path has been applied to all OSGi facets in the current project.";
            Messages.showInfoMessage((Project)this.myProject, (String)message, (String)"Output Path Applied");
        });
    }

    public void dispose() {
        this.myWatcher = null;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void applyTo(ProjectSettings settings) {
        FrameworkInstanceDefinition instance;
        String fileLocation = (String)this.myDefaultManifestFileLocation.getSelectedItem();
        if (fileLocation != null) {
            settings.setDefaultManifestFileLocation(fileLocation);
        }
        settings.setFrameworkInstanceName((instance = (FrameworkInstanceDefinition)((Object)this.myFrameworkInstance.getSelectedItem())) != null ? instance.getName() : null);
        String outputPath = this.myBundleOutputPath.getText();
        settings.setBundlesOutputPath(!StringUtil.isEmptyOrSpaces((String)outputPath) ? outputPath : null);
        settings.setBndAutoImport(this.myBndAutoImport.isSelected());
        this.myModified = false;
    }

    public void resetTo(ProjectSettings settings) {
        this.mySettings = settings;
        this.refreshFrameworkInstanceCombobox();
        this.myDefaultManifestFileLocation.setSelectedItem((Object)this.mySettings.getDefaultManifestFileLocation());
        String bundlesPath = this.mySettings.getBundlesOutputPath();
        if (bundlesPath != null) {
            this.myBundleOutputPath.setText(bundlesPath);
        } else {
            this.myBundleOutputPath.setText(ProjectSettings.getDefaultBundlesOutputPath(this.myProject));
        }
        this.myBndAutoImport.setSelected(settings.isBndAutoImport());
        this.myModified = false;
    }

    private void refreshFrameworkInstanceCombobox() {
        this.myFrameworkInstance.removeAllItems();
        this.myFrameworkInstance.addItem(null);
        List<FrameworkInstanceDefinition> instanceDefinitions = ApplicationSettings.getInstance().getActiveFrameworkInstanceDefinitions();
        String frameworkInstanceName = this.mySettings.getFrameworkInstanceName();
        FrameworkInstanceDefinition projectFrameworkInstance = null;
        for (FrameworkInstanceDefinition instanceDefinition : instanceDefinitions) {
            this.myFrameworkInstance.addItem(instanceDefinition);
            if (!instanceDefinition.getName().equals(frameworkInstanceName)) continue;
            projectFrameworkInstance = instanceDefinition;
        }
        if (projectFrameworkInstance == null && frameworkInstanceName != null) {
            projectFrameworkInstance = new FrameworkInstanceDefinition();
            projectFrameworkInstance.setName(frameworkInstanceName);
            this.myFrameworkInstance.addItem(projectFrameworkInstance);
        }
        this.myFrameworkInstance.setSelectedItem((Object)projectFrameworkInstance);
    }

    public boolean isModified() {
        return this.myModified;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        ComboBox comboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("OSGi framework:");
        jLabel.setDisplayedMnemonic('F');
        jLabel.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myFrameworkInstance = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Default manifest:");
        jLabel2.setDisplayedMnemonic('D');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, null, null, null));
        this.myDefaultManifestFileLocation = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Default manifest file location (relative to a module's content root)");
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 1, 0, null, null, null, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Output path:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Common output path for all compiled bundles");
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel3.setFontColor(UIUtil.FontColor.BRIGHTER);
        jPanel3.add((Component)jBLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 1, 0, null, null, null, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBundleOutputPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myApplyToAllButton = jButton = new JButton();
        jButton.setText("Apply  to all facets");
        jButton.setToolTipText("Modifies all OSGi facets and sets their output path settings so they use the common output path specified above.");
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 1, 0, null, null, null));
        this.myBndAutoImport = jBCheckBox = new JBCheckBox();
        jBCheckBox.setToolTipText("Update IDEA project model each time bnd.bnd or build.bnd file is changed ");
        jBCheckBox.setText("Import Bnd/Bndtools projects automatically");
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jComboBox);
        jLabel2.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

