/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.createproject.ActionTypeDescription;
import com.jetbrains.plugins.webDeployment.actions.createproject.BaseStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseServerStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseWebPathStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.CreateProjectModel;
import com.jetbrains.plugins.webDeployment.actions.createproject.ServerTreeForm;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ChooseRemotePathStep
extends BaseStep {
    public static final ActionTypeDescription.Remote[] REMOTE_ACTION_TYPE_DESCRIPTIONS = new ActionTypeDescription.Remote[]{ActionTypeDescription.REMOTE_RESOURCE_ROOTS_ACTION_DESCRIPTION, ActionTypeDescription.REMOTE_EXCLUDE_FOLDERS_ACTION_DESCRIPTION};
    public static final Object ID = ChooseRemotePathStep.class;
    private JPanel myContentPane;
    private ServerTreeForm myBrowserForm;

    public ChooseRemotePathStep(CreateProjectModel model) {
        super(WDBundle.message("create.web.project.choose.remote.path.step.title", new Object[0]), model);
        this.$$$setupUI$$$();
        this.myBrowserForm.addStateChangedListener(new ServerTreeForm.RootChangedListener(){

            @Override
            public void rootChanged() {
                ChooseRemotePathStep.this.fireStateChanged();
            }
        });
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/createproject/ChooseRemotePathStep", "getStepId"));
        }
        return object;
    }

    public Object getNextStepId() {
        return ChooseWebPathStep.ID;
    }

    public Object getPreviousStepId() {
        return ChooseServerStep.ID;
    }

    public boolean isComplete() {
        if (this.myModel.scenario == CreateProjectModel.Scenario.NoServer || this.myModel.scenario == CreateProjectModel.Scenario.LocalServer) {
            return true;
        }
        String path = this.myBrowserForm.getProjectRootPath();
        return StringUtil.isNotEmpty((String)path);
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        String path = this.myBrowserForm.getProjectRootPath();
        if (commitType == AbstractWizardStepEx.CommitType.Prev) {
            return;
        }
        this.myModel.setServerPath(new WebServerConfig.RemotePath(path));
        String projectRootPathOnServer = ((DeploymentPathMapping)this.myBrowserForm.getTempMapping().getFirst()).getDeployPath();
        this.processExcludedPaths(projectRootPathOnServer);
        this.processActionPaths(projectRootPathOnServer);
    }

    private void processExcludedPaths(String projectRootPathOnServer) {
        boolean isMountedFolder = !this.myModel.getServer().getFileTransferConfig().getAccessType().isProtocolBased();
        String mountedFolder = this.myModel.getServer().getFileTransferConfig().getMountedFolder();
        List<ExcludedPath> excludedPaths = this.myModel.getConfig().getExcludedPaths(this.myModel.getServer().getId());
        ArrayList<ExcludedPath> localExcludedPaths = new ArrayList<ExcludedPath>(excludedPaths.size());
        WebServerConfig.RemotePath projectPathToCheck = isMountedFolder ? new WebServerConfig.RemotePath(DeploymentPathUtils.join(mountedFolder, projectRootPathOnServer, File.separatorChar)) : new WebServerConfig.RemotePath(projectRootPathOnServer);
        boolean addProjectRoot = false;
        Iterator<ExcludedPath> it = excludedPaths.iterator();
        while (it.hasNext()) {
            WebServerConfig.RemotePath deployPath;
            String remainder;
            ExcludedPath next = it.next();
            if (next.isLocal()) continue;
            String pathToCheck = next.getPath();
            if (isMountedFolder) {
                pathToCheck = DeploymentPathUtils.join(mountedFolder, next.getPath(), File.separatorChar);
            }
            if ((remainder = DeploymentPathMapping.getPathRemainderForRemotePath(deployPath = new WebServerConfig.RemotePath(pathToCheck), this.myModel.getServer(), projectRootPathOnServer)) == null) {
                if (DeploymentPathMapping.getPathRemainderForRemotePath(projectPathToCheck, this.myModel.getServer(), next.getPath()) != null) {
                    addProjectRoot = true;
                    break;
                }
                it.remove();
                continue;
            }
            DeploymentPathMapping result = null;
            for (DeploymentPathMapping mapping : this.myModel.getConfig().getPathMappings(this.myModel.getServer().getId())) {
                if (!mapping.isLocalPathValid() || !mapping.isParentForDeployPath(deployPath, false, this.myModel.getServer()) || result != null && !result.isParentByDeployPath(mapping, this.myModel.getServer().isCaseSensitive())) continue;
                result = mapping;
            }
            String localPath = result.mapToLocalPath(deployPath, this.myModel.getServer());
            ExcludedPath newLocalPath = new ExcludedPath(FileUtil.toSystemDependentName((String)localPath), true);
            localExcludedPaths.add(newLocalPath);
        }
        if (addProjectRoot) {
            excludedPaths.clear();
            excludedPaths.add(new ExcludedPath(projectRootPathOnServer, false));
            String localPath = this.myModel.localPath;
            ExcludedPath newLocalPath = new ExcludedPath(FileUtil.toSystemDependentName((String)localPath), true);
            localExcludedPaths.add(newLocalPath);
        }
        excludedPaths.addAll(localExcludedPaths);
        this.myModel.getConfig().setExcludedPaths(this.myModel.getServer().getId(), excludedPaths);
    }

    private void processActionPaths(String projectRootPathOnServer) {
        boolean isMountedFolder = !this.myModel.getServer().getFileTransferConfig().getAccessType().isProtocolBased();
        String mountedFolder = this.myModel.getServer().getFileTransferConfig().getMountedFolder();
        MultiMap<String, WebServerConfig.RemotePath> actionPaths = this.myBrowserForm.getActionPaths();
        MultiMap validActionPaths = new MultiMap();
        WebServerConfig.RemotePath projectPathToCheck = isMountedFolder ? new WebServerConfig.RemotePath(DeploymentPathUtils.join(mountedFolder, projectRootPathOnServer, File.separatorChar)) : new WebServerConfig.RemotePath(projectRootPathOnServer);
        for (String key : actionPaths.keySet()) {
            boolean isRecursive = false;
            for (ActionTypeDescription.Remote actionTypeDescription : REMOTE_ACTION_TYPE_DESCRIPTIONS) {
                if (!actionTypeDescription.key.equals(key)) continue;
                isRecursive = actionTypeDescription.isRecursive;
                break;
            }
            HashSet<WebServerConfig.RemotePath> actionPathsToCommit = new HashSet<WebServerConfig.RemotePath>();
            boolean addRoot = false;
            WebServerConfig.RemotePath projectRemotePath = new WebServerConfig.RemotePath(projectRootPathOnServer);
            for (WebServerConfig.RemotePath remotePath : actionPaths.get((Object)key)) {
                WebServerConfig.RemotePath newRemotePath = new WebServerConfig.RemotePath(ServerTreeForm.getMountedServerRelativePath(remotePath.path, this.myModel.getServer()));
                if (this.myModel.getConfig().getNearestMappingDeploy2Local(remotePath, false, this.myModel.getServer()).getFirst() != null) {
                    actionPathsToCommit.add(newRemotePath);
                    continue;
                }
                if (!isRecursive || DeploymentPathMapping.getPathRemainderForRemotePath(projectPathToCheck, this.myModel.getServer(), newRemotePath.path) == null) continue;
                addRoot = true;
                break;
            }
            if (addRoot) {
                actionPathsToCommit.clear();
                if (this.myModel.getConfig().getNearestMappingDeploy2Local(projectPathToCheck, false, this.myModel.getServer()).getFirst() != null) {
                    actionPathsToCommit.add(projectRemotePath);
                }
            }
            validActionPaths.putValues((Object)key, actionPathsToCommit);
        }
        this.myModel.getRemoteActionPaths().clear();
        this.myModel.getRemoteActionPaths().putAllValues(validActionPaths);
    }

    @Override
    public JComponent getInnerComponent() {
        return this.myContentPane;
    }

    @Override
    public void doInit() {
        ArrayList<DeploymentPathMapping> mappings = this.myModel.getConfig().getAllPathMappings().get(this.myModel.getServer().getId());
        boolean initialized = false;
        if (mappings != null) {
            for (DeploymentPathMapping mapping : mappings) {
                if (!(mapping instanceof TempDeploymentPathMapping)) continue;
                initialized = true;
                break;
            }
        }
        if (!initialized) {
            mappings = mappings == null ? new ArrayList<DeploymentPathMapping>() : mappings;
            TempDeploymentPathMapping mapping = new TempDeploymentPathMapping();
            mapping.setLocalPath(this.myModel.localPath);
            mappings.add(mapping);
            this.myModel.getConfig().setPathMappings(this.myModel.getServer().getId(), mappings);
        }
        this.myBrowserForm.initialize(this.myModel.getServer(), true, this.myModel.getConfig(), this.myModel.getServerPath());
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myBrowserForm);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBrowserForm.getPreferredFocusedComponent();
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.from.existing.files.choose.remote.path";
    }

    @Override
    @Nls
    @NotNull
    protected String getSummaryText() {
        String string = WDBundle.message("create.web.project.choose.remote.path.step.summary", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/createproject/ChooseRemotePathStep", "getSummaryText"));
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ServerTreeForm serverTreeForm;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.myBrowserForm = serverTreeForm = new ServerTreeForm();
        JComponent jComponent = serverTreeForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static class TempDeploymentPathMapping
    extends DeploymentPathMapping {
        public DeploymentPathMapping cloneAsDeploymentPathMapping() {
            DeploymentPathMapping mapping = new DeploymentPathMapping();
            mapping.setLocalPath(this.getLocalPath());
            mapping.setDeployPath(this.getDeployPath());
            mapping.setWebPath(this.getWebPath());
            return mapping;
        }
    }
}

