/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersAuthStorage;
import com.jetbrains.plugins.webDeployment.config.WebServersPasswordHelper;
import com.jetbrains.plugins.webDeployment.config.sftp.SftpAdvancedOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class WebServersConfigManagerBaseImpl<T extends State>
implements PersistentStateComponent<T> {
    protected T myState = this.createState();
    private final boolean isProjectLevel;
    private List<Listener> myListeners = new SmartList();

    public WebServersConfigManagerBaseImpl(boolean level) {
        this.isProjectLevel = level;
    }

    void initPasswordSafeIntegration(Disposable disposable) {
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(PasswordSafeSettings.TOPIC, (Object)new PasswordSafeSettingsListener(){

            public void typeChanged(@NotNull PasswordSafeSettings.ProviderType oldValue, @NotNull PasswordSafeSettings.ProviderType newValue) {
                if (oldValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$1", "typeChanged"));
                }
                if (newValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$1", "typeChanged"));
                }
                if (oldValue == newValue || newValue == PasswordSafeSettings.ProviderType.MASTER_PASSWORD) {
                    return;
                }
                for (WebServerConfig server : ((State)WebServersConfigManagerBaseImpl.this.myState).servers) {
                    FileTransferConfig config = server.getFileTransferConfig();
                    config.updateOnPasswordStoreImpossible();
                    config.updateOnPassphraseStoreImpossible();
                }
            }

            public void credentialStoreCleared() {
                for (WebServerConfig server : ((State)WebServersConfigManagerBaseImpl.this.myState).servers) {
                    FileTransferConfig config = server.getFileTransferConfig();
                    config.passwordStoreCleared();
                }
            }
        });
    }

    protected abstract T createState();

    @Deprecated
    public T getState() {
        T state = this.createState();
        for (WebServerConfig server : ((State)this.myState).servers) {
            WebServerConfig clone = server.clone();
            clone.setIsProjectLevel(false);
            ((State)state).servers.add(clone);
        }
        return state;
    }

    public void loadState(T state) {
        this.myState = state;
        for (WebServerConfig server : ((State)this.myState).servers) {
            if (StringUtil.isEmpty((String)server.getId())) {
                server.setId(WebServerConfig.getNextId());
            }
            server.setIsProjectLevel(this.isProjectLevel);
        }
        WebServerConfig.fixDuplicatingNames(((State)this.myState).servers);
        this.getAuthStorage().initServerAuthIfNeeded(((State)this.myState).servers);
        WebServersPasswordHelper.syncWithPasswordSafe(((State)this.myState).servers);
        this.fireServersLoaded();
    }

    protected abstract WebServersAuthStorage getAuthStorage();

    private void fireServersLoaded() {
        for (Listener listener : this.myListeners) {
            listener.serversLoaded();
        }
    }

    public void addListener(Listener listener, Disposable parentDisposable) {
        ContainerUtil.add((Object)listener, this.myListeners, (Disposable)parentDisposable);
    }

    static interface Listener {
        public void serversLoaded();
    }

    @com.intellij.openapi.components.State(name="WebServers", storages={@Storage(value="webServers.xml")})
    public static class App
    extends WebServersConfigManagerBaseImpl<AppState>
    implements ExportableComponent {
        public App() {
            super(false);
            this.initPasswordSafeIntegration((Disposable)ApplicationManager.getApplication());
        }

        @Override
        protected AppState createState() {
            return new AppState();
        }

        @Override
        public AppState getState() {
            AppState state = (AppState)super.getState();
            state.mySftpAdvancedOptions = ((AppState)this.myState).mySftpAdvancedOptions.clone();
            return state;
        }

        @Override
        protected WebServersAuthStorage getAuthStorage() {
            return WebServersAuthStorage.AppInstance.getInstance();
        }

        @NotNull
        public SftpAdvancedOptions getSftpAdvancedOptions() {
            SftpAdvancedOptions sftpAdvancedOptions = ((AppState)this.myState).mySftpAdvancedOptions.clone();
            if (sftpAdvancedOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App", "getSftpAdvancedOptions"));
            }
            return sftpAdvancedOptions;
        }

        public void setSftpAdvancedOptions(@NotNull SftpAdvancedOptions options) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App", "setSftpAdvancedOptions"));
            }
            ((AppState)this.myState).mySftpAdvancedOptions = options.clone();
        }

        @NotNull
        public File[] getExportFiles() {
            File[] fileArray = new File[]{PathManager.getOptionsFile((String)"webServers")};
            if (fileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App", "getExportFiles"));
            }
            return fileArray;
        }

        @NotNull
        public String getPresentableName() {
            String string = WDBundle.message("web.servers.exportable.component.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App", "getPresentableName"));
            }
            return string;
        }
    }

    public static class AppState
    extends State {
        @Tag(value="sftpAdvancedGlobalOptions")
        public SftpAdvancedOptions mySftpAdvancedOptions = new SftpAdvancedOptions();
    }

    @com.intellij.openapi.components.State(name="WebServers", storages={@Storage(value="webServers.xml")})
    public static class Project
    extends WebServersConfigManagerBaseImpl<State> {
        @NotNull
        private final com.intellij.openapi.project.Project myProject;

        public Project(@NotNull com.intellij.openapi.project.Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$Project", "<init>"));
            }
            super(true);
            this.myProject = project;
            this.initPasswordSafeIntegration((Disposable)this.myProject);
        }

        @Override
        protected State createState() {
            return new State();
        }

        @Override
        protected WebServersAuthStorage getAuthStorage() {
            return WebServersAuthStorage.ProjectInstance.getInstance(this.myProject);
        }
    }

    public static class State {
        @AbstractCollection(surroundWithTag=false)
        public List<WebServerConfig> servers = new ArrayList<WebServerConfig>();
    }
}

