/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServersPasswordHelper {
    static void syncWithPasswordSafe(List<WebServerConfig> servers) {
        PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
        for (WebServerConfig server : servers) {
            for (Data data : Data.values()) {
                data.sync((PasswordSafe)passwordSafe, server);
            }
        }
    }

    public static void saveServer(WebServerConfig server) {
        PasswordSafe passwordSafe = PasswordSafe.getInstance();
        WebServersPasswordHelper.doSaveServer(passwordSafe, server);
    }

    private static void doSaveServer(PasswordSafe passwordSafe, WebServerConfig server) {
        for (Data data : Data.values()) {
            data.save(passwordSafe, server);
        }
    }

    public static void updateData(List<WebServerConfig> servers, Set<String> oldIds) {
        PasswordSafe passwordSafe = PasswordSafe.getInstance();
        for (WebServerConfig server : servers) {
            WebServersPasswordHelper.doSaveServer(passwordSafe, server);
            oldIds.remove(server.getId());
        }
        for (String id : oldIds) {
            for (Data data : Data.values()) {
                data.clear(passwordSafe, id);
            }
        }
    }

    public static String getActualUserName(WebServerConfig server, PasswordSafe passwordSafe) {
        return WebServersPasswordHelper.getActualData(server, Data.UserName, passwordSafe);
    }

    public static String getActualPassword(WebServerConfig server, PasswordSafe passwordSafe) {
        return WebServersPasswordHelper.getActualData(server, Data.Password, passwordSafe);
    }

    public static String getActualPassphrase(WebServerConfig server, PasswordSafe passwordSafe) {
        return WebServersPasswordHelper.getActualData(server, Data.Passphrase, passwordSafe);
    }

    private static String getActualData(WebServerConfig server, Data data, PasswordSafe passwordSafe) {
        return data.get(passwordSafe, server);
    }

    private static enum Data {
        UserName{

            @Override
            @NonNls
            @NotNull
            String getKey(String serverId) {
                String string = "username." + serverId;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersPasswordHelper$Data$1", "getKey"));
                }
                return string;
            }

            @Override
            @Nullable
            protected String getDataToStore(WebServerConfig server) {
                return server.getFileTransferConfig().getUserName();
            }

            @Override
            protected void applyToServer(WebServerConfig server, @NotNull String saved) {
                if (saved == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saved", "com/jetbrains/plugins/webDeployment/config/WebServersPasswordHelper$Data$1", "applyToServer"));
                }
                server.getFileTransferConfig().setUserName(saved);
            }

            @Override
            void save(PasswordSafe passwordSafe, WebServerConfig server) {
                Data.save(UserName, passwordSafe, server, false);
            }
        }
        ,
        Password{

            @Override
            @NonNls
            @NotNull
            String getKey(String serverId) {
                String string = "password." + serverId;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersPasswordHelper$Data$2", "getKey"));
                }
                return string;
            }

            @Override
            @Nullable
            protected String getDataToStore(WebServerConfig server) {
                FileTransferConfig config = server.getFileTransferConfig();
                return config.getPasswordState() == FileTransferConfig.PasswordState.Unspecified ? null : config.getPassword();
            }

            @Override
            protected void applyToServer(WebServerConfig server, @NotNull String saved) {
                if (saved == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saved", "com/jetbrains/plugins/webDeployment/config/WebServersPasswordHelper$Data$2", "applyToServer"));
                }
                server.getFileTransferConfig().setPassword(saved, true);
                server.getFileTransferConfig().setStorePassword(true);
            }

            @Override
            void save(PasswordSafe passwordSafe, WebServerConfig server) {
                FileTransferConfig config = server.getFileTransferConfig();
                if (config.getPasswordState() == FileTransferConfig.PasswordState.Store) {
                    Data.save(Password, passwordSafe, server, false);
                } else if (config.getPasswordState() == FileTransferConfig.PasswordState.Specified) {
                    this.clear(passwordSafe, server.getId());
                    Data.save(Password, passwordSafe, server, true);
                } else {
                    this.clear(passwordSafe, server.getId());
                }
            }
        }
        ,
        Passphrase{

            @Override
            @NonNls
            @NotNull
            String getKey(String serverId) {
                String string = "passphrase." + serverId;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersPasswordHelper$Data$3", "getKey"));
                }
                return string;
            }

            @Override
            @Nullable
            protected String getDataToStore(WebServerConfig server) {
                FileTransferConfig config = server.getFileTransferConfig();
                return config.getPassphraseState() == FileTransferConfig.PasswordState.Unspecified ? null : config.getPassphrase();
            }

            @Override
            protected void applyToServer(WebServerConfig server, @NotNull String saved) {
                if (saved == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saved", "com/jetbrains/plugins/webDeployment/config/WebServersPasswordHelper$Data$3", "applyToServer"));
                }
                server.getFileTransferConfig().setPassphrase(saved, true);
                server.getFileTransferConfig().setStorePassphrase(true);
            }

            @Override
            void save(PasswordSafe passwordSafe, WebServerConfig server) {
                FileTransferConfig config = server.getFileTransferConfig();
                if (config.getPassphraseState() == FileTransferConfig.PasswordState.Store) {
                    Data.save(Passphrase, passwordSafe, server, false);
                } else if (config.getPassphraseState() == FileTransferConfig.PasswordState.Specified) {
                    this.clear(passwordSafe, server.getId());
                    Data.save(Passphrase, passwordSafe, server, true);
                } else {
                    this.clear(passwordSafe, server.getId());
                }
            }
        };


        @Nullable
        String get(PasswordSafe passwordSafe, WebServerConfig server) {
            return passwordSafe.getPassword(this.getAttributes(server.getId()));
        }

        @NonNls
        @NotNull
        abstract String getKey(String var1);

        @NotNull
        CredentialAttributes getAttributes(String serverId) {
            CredentialAttributes credentialAttributes = CredentialAttributesKt.CredentialAttributes(WebServersPasswordHelper.class, (String)this.getKey(serverId));
            if (credentialAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersPasswordHelper$Data", "getAttributes"));
            }
            return credentialAttributes;
        }

        static void save(Data data, PasswordSafe passwordSafe, WebServerConfig server, boolean memoryOnly) {
            String value = data.getDataToStore(server);
            CredentialAttributes attributes = data.getAttributes(server.getId());
            passwordSafe.set(attributes, value == null ? null : new Credentials(attributes.getUserName(), value), memoryOnly);
        }

        abstract void save(PasswordSafe var1, WebServerConfig var2);

        @Nullable
        protected abstract String getDataToStore(WebServerConfig var1);

        void sync(PasswordSafe passwordSafe, WebServerConfig server) {
            String saved = this.get(passwordSafe, server);
            if (saved != null) {
                this.applyToServer(server, saved);
            } else {
                this.save(passwordSafe, server);
            }
        }

        protected abstract void applyToServer(WebServerConfig var1, @NotNull String var2);

        void clear(PasswordSafe passwordSafe, String serverId) {
            passwordSafe.set(this.getAttributes(serverId), null);
        }
    }
}

