/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit.fs;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.LocalTimeCounter;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteDeploymentFileSystem;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteFileContent;
import com.jetbrains.plugins.webDeployment.remoteEdit.notification.RemoteEditEditorDecorator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteVirtualFile
extends VirtualFile {
    private static final Logger LOG = Logger.getInstance(RemoteVirtualFile.class);
    private final WebServerConfig myServerConfig;
    private final VirtualFile myDelegate;
    private final String myPath;
    private final String myName;
    private final RemoteDeploymentFileSystem myFileSystem;
    private final RemoteConnection myConnection;
    private final FileObject myDestination;
    private final RemoteFileContent myContent;
    private long myModificationStamp;
    private final VirtualFile myParent;
    @Nullable
    private final String myPresentableServerName;

    RemoteVirtualFile(RemoteDeploymentFileSystem fileSystem, String path, String name, byte[] content, @NotNull WebServerConfig config, RemoteConnection connection, FileObject destination, @Nullable String presentableServerName) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteVirtualFile", "<init>"));
        }
        this.myModificationStamp = LocalTimeCounter.currentTime();
        this.myFileSystem = fileSystem;
        this.myConnection = connection;
        this.myDestination = destination;
        this.myServerConfig = config.clone();
        this.myDelegate = RemoteVirtualFile.createDelegateFile(name, content);
        this.myPath = path;
        this.myName = name;
        this.myContent = new RemoteFileContent();
        this.myPresentableServerName = presentableServerName;
        this.updateLastSyncedContent(content);
        this.myParent = new BinaryLightVirtualFile(""){

            @NotNull
            public VirtualFileSystem getFileSystem() {
                VirtualFileSystem virtualFileSystem = RemoteVirtualFile.this.getFileSystem();
                if (virtualFileSystem == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteVirtualFile$1", "getFileSystem"));
                }
                return virtualFileSystem;
            }

            public boolean isWritable() {
                return false;
            }

            public boolean isDirectory() {
                return true;
            }

            public VirtualFile[] getChildren() {
                return new VirtualFile[]{RemoteVirtualFile.this};
            }
        };
    }

    @NotNull
    private static LightVirtualFileBase createDelegateFile(String name, byte[] content) {
        BinaryLightVirtualFile binaryLightVirtualFile = new BinaryLightVirtualFile(name, content);
        if (binaryLightVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteVirtualFile", "createDelegateFile"));
        }
        return binaryLightVirtualFile;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteVirtualFile", "getName"));
        }
        return string;
    }

    public String getPresentableName() {
        if (UISettings.getInstance().HIDE_KNOWN_EXTENSION_IN_TABS && !this.isDirectory()) {
            String nameWithoutExtension = this.getNameWithoutExtension();
            return nameWithoutExtension.isEmpty() ? this.getName() : nameWithoutExtension;
        }
        return this.getName();
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        RemoteDeploymentFileSystem remoteDeploymentFileSystem = this.myFileSystem;
        if (remoteDeploymentFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteVirtualFile", "getFileSystem"));
        }
        return remoteDeploymentFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteVirtualFile", "getPath"));
        }
        return string;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return VirtualFile.EMPTY_ARRAY;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStreamWrapper outputStreamWrapper = new OutputStreamWrapper(this.myDelegate.getOutputStream(requestor, newModificationStamp, newTimeStamp), requestor, newModificationStamp);
        if (outputStreamWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteVirtualFile", "getOutputStream"));
        }
        return outputStreamWrapper;
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = this.myDelegate.contentsToByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    public long getTimeStamp() {
        return this.myDelegate.getTimeStamp();
    }

    public long getLength() {
        return this.myDelegate.getLength();
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Nullable
    public String getPresentableServerName() {
        return this.myPresentableServerName;
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        if (postRunnable != null) {
            postRunnable.run();
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.myDelegate.getInputStream();
    }

    public WebServerConfig getServerConfig() {
        return this.myServerConfig;
    }

    public RemoteConnection getClonedConnection() {
        return this.myConnection.clone();
    }

    public FileObject getDestination() {
        return this.myDestination;
    }

    public void updateLastSyncedContent(byte[] newContent) {
        this.myContent.setContent(newContent);
        RemoteEditEditorDecorator.updateDecorators(this);
    }

    public byte[] getLastSyncedContent() {
        return this.myContent.getContent();
    }

    public void revert(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteVirtualFile", "revert"));
        }
        document.setText((CharSequence)StringUtil.convertLineSeparators((String)new String(this.myContent.getContent(), this.getCharset())));
    }

    public boolean isChanged(@Nullable Document document) {
        byte[] current;
        if (FileDocumentManager.getInstance().isFileModified((VirtualFile)this)) {
            return true;
        }
        try {
            current = this.contentsToByteArray();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
        return this.isChanged(current);
    }

    public boolean isChanged(byte[] content) {
        return !Arrays.equals(content, this.myContent.getContent());
    }

    public WebServerConfig.RemotePath getRemotePath() {
        return this.myServerConfig.getRemotePath(this.myDestination);
    }

    private class OutputStreamWrapper
    extends OutputStream {
        private final OutputStream myDelegate;
        private final Object myRequestor;
        private final long myNewModificationStamp;

        public OutputStreamWrapper(OutputStream delegate, Object requestor, long newModificationStamp) {
            this.myRequestor = requestor;
            this.myNewModificationStamp = newModificationStamp;
            this.myDelegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.myDelegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.myDelegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.myDelegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.myDelegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.myDelegate.close();
            RemoteDeploymentFileSystem fs = (RemoteDeploymentFileSystem)RemoteVirtualFile.this.getFileSystem();
            fs.fireBeforeContentsChange(this.myRequestor, RemoteVirtualFile.this);
            long oldModStamp = RemoteVirtualFile.this.myModificationStamp;
            RemoteVirtualFile.this.myModificationStamp = RemoteVirtualFile.this.myModificationStamp >= 0L ? this.myNewModificationStamp : LocalTimeCounter.currentTime();
            fs.fireContentsChanged(this.myRequestor, RemoteVirtualFile.this, oldModStamp);
        }
    }
}

