/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginForm {
    private JPanel myContentPane;
    private JTextField myHostField;
    private JTextField myUsernameField;
    private JPasswordField myPasswordField;
    private JTextField myPrivateKeyField;
    private JLabel myPrivateKeyLabel;
    private JLabel myPasswordLabel;
    private JBCheckBox mySavePasswordCheckbox;

    public LoginForm(FileTransferConfig target) {
        this.$$$setupUI$$$();
        this.myHostField.setText(target.getHost() + ":" + target.getLiteralPort());
        this.myUsernameField.setText(target.getUserName());
        if (target.isUseKeyPair()) {
            this.myPrivateKeyLabel.setVisible(true);
            this.myPrivateKeyField.setVisible(true);
            this.myPrivateKeyField.setText(new File(target.getPrivateKeyFile()).getName());
            this.myPasswordLabel.setText(WDBundle.message("login.label.passphrase", new Object[0]));
            this.mySavePasswordCheckbox.setText(WDBundle.message("save.passphrase", new Object[0]));
        } else {
            this.myPrivateKeyLabel.setVisible(false);
            this.myPrivateKeyField.setVisible(false);
            this.myPasswordLabel.setText(WDBundle.message("login.label.password", new Object[0]));
            this.mySavePasswordCheckbox.setText(WDBundle.message("save.password", new Object[0]));
        }
        if (PasswordSafe.getInstance().isMemoryOnly()) {
            this.mySavePasswordCheckbox.setVisible(false);
        }
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPasswordField;
    }

    public String getUsername() {
        return this.myUsernameField.getText().trim();
    }

    public String getPassword() {
        return new String(this.myPasswordField.getPassword());
    }

    public boolean isSavePassword() {
        return this.mySavePasswordCheckbox.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JLabel jLabel;
        JPasswordField jPasswordField;
        JTextField jTextField2;
        JTextField jTextField3;
        JLabel jLabel2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(false);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Host:");
        jLabel3.setDisplayedMnemonic('H');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("User name:");
        jLabel4.setDisplayedMnemonic('U');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordLabel = jLabel2 = new JLabel();
        jLabel2.setText("Password:");
        jLabel2.setDisplayedMnemonic('A');
        jLabel2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostField = jTextField3 = new JTextField();
        ((Component)jTextField3).setEnabled(false);
        jPanel.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUsernameField = jTextField2 = new JTextField();
        ((Component)jTextField2).setEnabled(true);
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPrivateKeyLabel = jLabel = new JLabel();
        jLabel.setText("Private key:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrivateKeyField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySavePasswordCheckbox = jBCheckBox = new JBCheckBox();
        jPanel.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel3.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jPasswordField);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

