/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserForm;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerBrowserDialog
extends DialogWrapper {
    private ServerBrowserForm myForm;
    private final WebServerConfig myServer;
    private final boolean myFoldersOnly;
    @Nullable
    private final WebServerConfig.RemotePath myInitialPath;
    private final FileTransferConfig.Origin myOrigin;
    private final Project myProject;

    public ServerBrowserDialog(@NotNull Component component, WebServerConfig server, String title, boolean foldersOnly, FileTransferConfig.Origin origin, @Nullable WebServerConfig.RemotePath initialPath) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/webDeployment/ui/ServerBrowserDialog", "<init>"));
        }
        super(component, false);
        this.myProject = null;
        this.myServer = server;
        this.myFoldersOnly = foldersOnly;
        this.myInitialPath = initialPath;
        this.myOrigin = origin;
        this.init(title);
    }

    public ServerBrowserDialog(@NotNull Project project, WebServerConfig server, String title, boolean foldersOnly, FileTransferConfig.Origin origin, @Nullable WebServerConfig.RemotePath initialPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ui/ServerBrowserDialog", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        this.myServer = server;
        this.myFoldersOnly = foldersOnly;
        this.myInitialPath = initialPath;
        this.myOrigin = origin;
        this.init(title);
    }

    private void init(String title) {
        this.setSize(600, 400);
        this.setTitle(title);
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "ftp.server.browser";
    }

    protected JComponent createCenterPanel() {
        this.myForm = new ServerBrowserForm(this.myServer, this.myFoldersOnly, this.myOrigin, this.myInitialPath, this.myProject, this.isModal());
        return this.myForm.getContentPane();
    }

    protected void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myForm);
    }

    @Nullable
    public WebServerConfig.RemotePath getPath() {
        return this.myForm.getSelection();
    }
}

