/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.ServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.remoteEdit.EditRemoteFileAction;
import com.jetbrains.plugins.webDeployment.ui.DefaultServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.ui.HiddenPathsManager;
import com.jetbrains.plugins.webDeployment.ui.PropertyProvider;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowFactory;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeViewOptions;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.WebServerTreeBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerToolWindowPanel
extends SimpleToolWindowPanel
implements Disposable,
DataProvider {
    public static final String ACTION_GROUP = "RemoteHostViewPopupMenu";
    @NonNls
    private static final String HELP_ID = "reference.tool.window.remote.host";
    private final Project myProject;
    private WebServerCombo myServerCombo;
    private JPanel myViewContentPanel;
    private JPanel myTopPanel;
    private DefaultActionGroup myActionGroup;
    private ServerTree myTree;
    private Disposable myCurrentDisposable;
    private final MyToggleAction myShowSizeAction;
    private final MyToggleAction myShowTimestampAction;
    private final MyToggleAction myShowPermissionsAction;
    private final MyToggleAction myHighlightSymlinksAction;
    private final MyToggleAction myHighlightMappingsAction;
    private WebServerTreeBuilder myTreeBuilder;
    private final HiddenPathsManager myHiddenPathsManager;

    public WebServerToolWindowPanel(Project project, HiddenPathsManager hiddenPathsManager) {
        super(true);
        this.myProject = project;
        this.myHiddenPathsManager = hiddenPathsManager;
        this.myShowSizeAction = new MyToggleAction("toolwindow.show.size", false, false);
        this.myShowTimestampAction = new MyToggleAction("toolwindow.show.date", false, false);
        this.myShowPermissionsAction = new MyToggleAction("toolwindow.show.permissions", false, false);
        this.myHighlightSymlinksAction = new MyToggleAction("toolwindow.highlight.symlinks", true, false);
        this.myHighlightMappingsAction = new MyToggleAction("toolwindow.highlight.mappings", true, true);
        this.constructUi();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                WebServerToolWindowPanel.this.constructTree();
            }

            @Override
            public void optionsChanged() {
            }

            @Override
            public void excludedPathsChanged() {
            }
        });
    }

    private void constructUi() {
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        JPanel actionGroupPanel = new JPanel(new BorderLayout());
        this.myServerCombo = new WebServerCombo(true, 0, false);
        Disposer.register((Disposable)this, (Disposable)this.myServerCombo);
        this.myServerCombo.setProject(this.myProject);
        this.myServerCombo.getComboBox().setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.myServerCombo.getComboBox().setMinimumAndPreferredWidth(100);
        this.myServerCombo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WebServerToolWindowPanel.this.constructTree();
            }
        });
        JPanel comboPanel = new JPanel(new BorderLayout());
        comboPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        comboPanel.add((Component)((Object)this.myServerCombo), "Center");
        this.myTopPanel = new JPanel(new GridBagLayout());
        this.myTopPanel.add((Component)comboPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myTopPanel.add((Component)actionGroupPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myViewContentPanel = new JPanel();
        this.setToolbar(this.myTopPanel);
        this.setContent(this.myViewContentPanel);
        this.setBorder((Border)new ToolWindow.Border(true, false, false, false));
        this.myActionGroup = new DefaultActionGroup();
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)this.myActionGroup, true);
        toolBar.setSecondaryActionsTooltip(WDBundle.message("server.browser.view.options.label", new Object[0]));
        this.createToolbarActions();
        actionGroupPanel.add((Component)toolBar.getComponent(), "Center");
        WebServerConfig defaultServer = PublishConfig.getInstance(this.myProject).findDefaultServer();
        if (defaultServer != null && !defaultServer.needsTransfer()) {
            defaultServer = null;
        }
        this.myServerCombo.reset(defaultServer != null ? Pair.create((Object)defaultServer.getId(), (Object)defaultServer.getName()) : null);
        this.myServerCombo.setBorder(BorderFactory.createEmptyBorder());
        this.constructTree();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.SERVER_TREE, (Object)new DefaultServerTreeContentListener(null, null, null){

            @Override
            @Nullable
            protected WebServerTreeBuilder getTreeBuilder() {
                return WebServerToolWindowPanel.this.myTreeBuilder;
            }

            @Override
            @Nullable
            protected ServerTree getTree() {
                return WebServerToolWindowPanel.this.myTree;
            }

            @Override
            @Nullable
            protected WebServerConfig getServer() {
                return WebServerToolWindowPanel.this.myServerCombo.getSelectedServer();
            }
        });
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
            }

            @Override
            public void optionsChanged() {
                Object node;
                if (WebServerToolWindowPanel.this.myTree == null || WebServerToolWindowPanel.this.myTreeBuilder == null || WebServerToolWindowPanel.this.myTreeBuilder.isDisposed()) {
                    return;
                }
                WebServerConfig.RemotePath path = null;
                TreePath selection = WebServerToolWindowPanel.this.myTree.getSelectionPath();
                if (selection != null && (node = selection.getLastPathComponent()) instanceof ServerTreeNode) {
                    path = ((ServerTreeNode)((Object)node)).getPath();
                }
                ((ServerTreeContentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.SERVER_TREE)).refreshSubtree(WebServerToolWindowPanel.this.myServerCombo.getSelectedServer(), Collections.singleton(WebServerToolWindowPanel.this.myTreeBuilder.getRoot().getPath()), false, false, path, this);
            }

            @Override
            public void excludedPathsChanged() {
            }
        });
    }

    private void updateTreePresentation(boolean onlyIfActiveServer) {
        if (this.myTreeBuilder == null || onlyIfActiveServer && !this.isDefaultServerSelectedAndValid()) {
            return;
        }
        this.myTreeBuilder.queueUpdate();
    }

    private boolean isDefaultServerSelectedAndValid() {
        WebServerConfig selectedServer = this.myServerCombo.getSelectedServer();
        return selectedServer != null && selectedServer == PublishConfig.getInstance(this.myProject).findDefaultServer() && selectedServer.getFileTransferConfig().validateFast() == null;
    }

    private void constructTree() {
        JComponent treeComponent;
        WebServerConfig selectedServer;
        if (this.myCurrentDisposable != null) {
            Disposer.dispose((Disposable)this.myCurrentDisposable);
        }
        if ((selectedServer = this.myServerCombo.getSelectedServer()) != null && selectedServer.getFileTransferConfig().validateFast() == null) {
            this.myCurrentDisposable = new Disposable(){

                public void dispose() {
                    if (WebServerToolWindowPanel.this.myTreeBuilder != null) {
                        ((ServerTreeNode)((Object)WebServerToolWindowPanel.this.myTreeBuilder.getTreeStructure().getRootElement())).releaseConnection();
                        Disposer.dispose((Disposable)WebServerToolWindowPanel.this.myTreeBuilder);
                    }
                }
            };
            Disposer.register((Disposable)this, (Disposable)this.myCurrentDisposable);
            ServerTreeNode root = new ServerTreeNode(this.myProject, ConnectionOwnerFactory.createConnectionOwner(this.myProject), selectedServer, PublishConfig.getInstance(this.myProject), false, FileTransferConfig.Origin.Default, new ServerTreeViewOptions(){

                @Override
                public boolean isShowSize() {
                    return WebServerToolWindowPanel.this.myShowSizeAction.isSelected(null);
                }

                @Override
                public boolean isShowTimestamp() {
                    return WebServerToolWindowPanel.this.myShowTimestampAction.isSelected(null);
                }

                @Override
                public boolean isShowPermissions() {
                    return WebServerToolWindowPanel.this.myShowPermissionsAction.isSelected(null);
                }

                @Override
                public boolean isShowPermissionsAsNumber() {
                    return false;
                }

                @Override
                public boolean isHighlightSymlinks() {
                    return WebServerToolWindowPanel.this.myHighlightSymlinksAction.isSelected(null);
                }

                @Override
                public boolean isHighlightMappings() {
                    return WebServerToolWindowPanel.this.myHighlightMappingsAction.isSelected(null);
                }

                @Override
                public boolean isHidden(FileName name) {
                    return WebServerToolWindowPanel.this.myHiddenPathsManager.isHidden(selectedServer, name);
                }
            });
            this.myTree = new ServerTree(this.myProject, selectedServer, root);
            this.myTreeBuilder = WebServerTreeBuilder.createInstance(root, (JTree)((Object)this.myTree));
            treeComponent = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree));
            new TreeSpeedSearch((JTree)((Object)this.myTree));
            new EditSourceOnDoubleClickHandler.TreeMouseListener((JTree)((Object)this.myTree), null){

                protected void processDoubleClick(MouseEvent e, DataContext dataContext, TreeNode lastPathComponent) {
                    if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
                        return;
                    }
                    Object userObject = ((DefaultMutableTreeNode)lastPathComponent).getUserObject();
                    if (!(userObject instanceof ServerTreeNode)) {
                        return;
                    }
                    EditRemoteFileAction.editRemoteFile(dataContext, (ServerTreeNode)((Object)userObject));
                }
            }.installOn((Component)((Object)this.myTree));
            PopupHandler.installPopupHandler((JComponent)((Object)this.myTree), (String)ACTION_GROUP, (String)"RemoteHostPopup");
        } else {
            this.myTree = null;
            this.myTreeBuilder = null;
            String errorText = selectedServer != null ? WDBundle.message("remote.host.invalid", selectedServer.getName(), selectedServer.getFileTransferConfig().validateFast()) : this.myServerCombo.getSelectedErrorMessage();
            treeComponent = new JLabel(errorText, 0);
            treeComponent.setOpaque(true);
        }
        treeComponent.setBorder(BorderFactory.createEmptyBorder());
        this.myViewContentPanel.removeAll();
        UIUtil.removeScrollBorder((Component)treeComponent);
        this.myViewContentPanel.setLayout(new BorderLayout());
        this.myViewContentPanel.add((Component)treeComponent, "Center");
        this.myViewContentPanel.revalidate();
        this.myViewContentPanel.repaint();
        this.myTopPanel.revalidate();
    }

    private void createToolbarActions() {
        this.myActionGroup.removeAll();
        this.myActionGroup.addAction(CommonActionsManager.getInstance().createCollapseAllAction(new TreeExpander(){

            public void expandAll() {
            }

            public boolean canExpand() {
                return false;
            }

            public void collapseAll() {
                ServerTree tree = WebServerToolWindowPanel.this.myTree;
                if (tree == null) {
                    return;
                }
                MutableTreeNode root = (MutableTreeNode)tree.getModel().getRoot();
                Enumeration<? extends TreeNode> rootChildren = root.children();
                while (rootChildren.hasMoreElements()) {
                    TreePath treePath = new TreePath(new Object[]{root, rootChildren.nextElement()});
                    tree.collapsePath(treePath);
                }
            }

            public boolean canCollapse() {
                return WebServerToolWindowPanel.this.myTree != null;
            }
        }, (JComponent)((Object)this)));
        RefreshAction refreshAction = new RefreshAction(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(WebServerToolWindowPanel.this.myTree != null);
            }

            public void actionPerformed(AnActionEvent e) {
                if (WebServerToolWindowPanel.this.myTreeBuilder == null || WebServerToolWindowPanel.this.myTreeBuilder.isDisposed()) {
                    return;
                }
                FileObject fileObject = WebServerToolWindowPanel.this.myTreeBuilder.getRoot().getFileObject();
                if (fileObject != null) {
                    PublishUtils.getManager().getFilesCache().clear(fileObject.getFileSystem());
                }
                WebServerToolWindowPanel.this.myTreeBuilder.refreshRoot();
            }
        };
        refreshAction.registerShortcutOn((JComponent)((Object)this));
        this.myActionGroup.addAction((AnAction)refreshAction);
        this.myActionGroup.addAction((AnAction)new MyCloseAction());
        this.myActionGroup.addAction((AnAction)new ContextHelpAction(HELP_ID));
    }

    public void installGearActions(ToolWindowEx window) {
        DefaultActionGroup gearActions = new DefaultActionGroup();
        gearActions.add((AnAction)this.myShowSizeAction);
        gearActions.add((AnAction)this.myShowTimestampAction);
        gearActions.add((AnAction)this.myShowPermissionsAction);
        gearActions.add((AnAction)this.myHighlightSymlinksAction);
        gearActions.add((AnAction)this.myHighlightMappingsAction);
        window.setAdditionalGearActions((ActionGroup)gearActions);
    }

    public void dispose() {
        this.myTree = null;
        this.myTreeBuilder = null;
        ToolWindowManager.getInstance((Project)this.myProject).unregisterToolWindow(WebServerToolWindowFactory.SERVER_BROWSER_TOOLWINDOW);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (WebDeploymentDataKeys.SERVER_CONFIG.is(dataId)) {
            return this.myServerCombo.getSelectedServer();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return null;
    }

    public void selectInServer(@Nullable Project project, @NotNull String serverId, @NotNull WebServerConfig.RemotePath path) {
        if (serverId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverId", "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel", "selectInServer"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel", "selectInServer"));
        }
        WebServerConfig server = WebServersConfigManager.getInstance(project).findServer(serverId);
        if (server == null) {
            return;
        }
        this.myServerCombo.selectServer(server);
        if (this.myTreeBuilder != null) {
            this.myTreeBuilder.selectPath(path);
            IdeFocusManager.findInstanceByComponent((Component)((Object)this.myTree)).requestFocus((Component)((Object)this.myTree), true);
        }
    }

    private class MyCloseAction
    extends CloseTabToolbarAction {
        private MyCloseAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)WebServerToolWindowPanel.this.myProject);
            ToolWindow toolWindow = manager.getToolWindow(WebServerToolWindowFactory.SERVER_BROWSER_TOOLWINDOW);
            if (toolWindow != null) {
                toolWindow.hide(() -> {
                    toolWindow.getContentManager().removeAllContents(true);
                    WebServerToolWindowFactory.setAvailable(WebServerToolWindowPanel.this.myProject, false);
                });
            }
        }
    }

    private class MyToggleAction
    extends ToggleAction
    implements DumbAware {
        private boolean mySelected;
        private final PropertyProvider myStoredValue;
        private final boolean myIsForActiveServer;

        public MyToggleAction(String textKey, String description, Icon icon, boolean defaultValue, boolean isForActiveServer) {
            super(WDBundle.message(textKey, new Object[0]), description, icon);
            this.myIsForActiveServer = isForActiveServer;
            this.myStoredValue = new PropertyProvider(WebServerToolWindowPanel.this.myProject, "WebServerToolWindowPanel." + textKey, String.valueOf(defaultValue));
            this.mySelected = Boolean.parseBoolean(this.myStoredValue.readValue());
        }

        public MyToggleAction(String textKey, boolean defaultValue, boolean isForActiveServer) {
            this(textKey, null, null, defaultValue, isForActiveServer);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySelected;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySelected = state;
            this.myStoredValue.saveValue(String.valueOf(this.mySelected));
            this.updateTree();
        }

        protected void updateTree() {
            WebServerToolWindowPanel.this.updateTreePresentation(this.myIsForActiveServer);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            if (this.myIsForActiveServer) {
                e.getPresentation().setVisible(WebServerToolWindowPanel.this.isDefaultServerSelectedAndValid());
            }
        }
    }
}

