/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.auth;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.hash.HashMap;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServersPasswordHelper;
import com.jetbrains.plugins.webDeployment.ui.auth.LoginDialog;
import com.jetbrains.plugins.webDeployment.ui.auth.LoginDialogCreator;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthHelper {
    private static final Logger LOG = Logger.getInstance((String)AuthHelper.class.getName());
    private static final Map<Pair<WebServerConfig, Boolean>, Collection<AuthPair>> LOGIN_SERVERS = new HashMap();

    public static boolean ensureAuthSpecified(@Nullable Project project, @NotNull WebServerConfig target, @NotNull Component component) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        return AuthHelper.ensureAuthSpecified(project, target, ConnectionOwnerFactory.createConnectionOwner(component));
    }

    public static boolean ensureAuthSpecified(final @NotNull WebServerConfig target, final @Nullable Project project) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        final boolean modal = ApplicationManager.getApplication().isDispatchThread();
        return AuthHelper.ensureAuthSpecified(project, target, new LoginDialogCreator(){

            @Override
            public LoginDialog createDialog() {
                return new LoginDialog(target, project, modal);
            }
        }, modal);
    }

    public static boolean ensureAuthSpecified(@Nullable Project project, final @NotNull WebServerConfig target, final @NotNull ConnectionOwner connectionOwner) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        final boolean modal = ApplicationManager.getApplication().isDispatchThread();
        return AuthHelper.ensureAuthSpecified(project, target, new LoginDialogCreator(){

            @Override
            public LoginDialog createDialog() {
                return LoginDialog.createInstance(target, connectionOwner, modal);
            }
        }, modal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ensureAuthSpecified(final @Nullable Project project, final WebServerConfig target, LoginDialogCreator dialog, final boolean modal) {
        boolean needToShow;
        if (!target.getFileTransferConfig().getAccessType().isProtocolBased() || AuthHelper.hasPassword(false, target.getFileTransferConfig())) {
            return true;
        }
        final AuthPair resultPair = new AuthPair();
        final Pair targetKey = Pair.create((Object)target, (Object)modal);
        Map<Pair<WebServerConfig, Boolean>, Collection<AuthPair>> map = LOGIN_SERVERS;
        synchronized (map) {
            Collection<AuthPair> refs = LOGIN_SERVERS.get(targetKey);
            if (refs == null) {
                needToShow = true;
                LOGIN_SERVERS.put((Pair<WebServerConfig, Boolean>)targetKey, new ArrayList());
            } else {
                LOG.assertTrue(!modal);
                needToShow = false;
                refs.add(resultPair);
                try {
                    Collection<AuthPair> pairs;
                    while ((pairs = LOGIN_SERVERS.get(targetKey)) != null && pairs.contains(resultPair)) {
                        LOGIN_SERVERS.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (needToShow) {
            LOG.assertTrue(project != null || !target.isProjectLevel(), (Object)("Project '" + target.getName() + "' is project-level one. Please provide project."));
            final Semaphore done = new Semaphore();
            Runnable runnable = () -> {
                final LoginDialog d = dialog.createDialog();
                AsyncResult<Boolean> result = d.showAndGetResult();
                result.doWhenDone((Consumer)new Consumer<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void consume(Boolean ok) {
                        if (ok.booleanValue()) {
                            resultPair.username = d.getUsername();
                            resultPair.password = d.getPassword();
                            resultPair.savePassword = d.isSavePassword();
                        }
                        if (ok.booleanValue() && d.isSavePassword()) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                List<WebServerConfig> serversList = WebServersConfigManager.getInstance(project).getServers(false);
                                WebServerConfig[] servers = serversList.toArray(new WebServerConfig[serversList.size()]);
                                boolean found = false;
                                String id = target.getId();
                                for (WebServerConfig server : servers) {
                                    if (!id.equals(server.getId())) continue;
                                    FileTransferConfig config = server.getFileTransferConfig();
                                    config.setUserName(resultPair2.username);
                                    if (config.isUseKeyPair()) {
                                        config.setPassphrase(resultPair2.password, false);
                                        config.setStorePassphrase(true);
                                    } else {
                                        config.setPassword(resultPair2.password, false);
                                        config.setStorePassword(true);
                                    }
                                    found = true;
                                    WebServersPasswordHelper.saveServer(server);
                                    break;
                                }
                                if (found) {
                                    WebServersConfigManager.getInstance(project).setServers(Arrays.asList(servers));
                                    ((DeploymentConfigChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).deploymentConfigChanged();
                                }
                            });
                        }
                        Map map = LOGIN_SERVERS;
                        synchronized (map) {
                            for (AuthPair pair : (Collection)LOGIN_SERVERS.remove(targetKey)) {
                                pair.username = resultPair.username;
                                pair.password = resultPair.password;
                                pair.savePassword = resultPair.savePassword;
                            }
                            LOGIN_SERVERS.notifyAll();
                        }
                        if (!modal) {
                            done.up();
                        }
                    }
                });
            };
            if (!modal) {
                done.down();
                ApplicationManager.getApplication().invokeAndWait(runnable);
                done.waitFor();
            } else {
                runnable.run();
            }
        }
        if (resultPair.username == null || resultPair.password == null) {
            return false;
        }
        FileTransferConfig config = target.getFileTransferConfig();
        config.setUserName(resultPair.username);
        if (config.isUseKeyPair()) {
            config.setPassphrase(resultPair.password, true);
            config.setStorePassphrase(resultPair.savePassword);
        } else {
            config.setPassword(resultPair.password, true);
            config.setStorePassword(resultPair.savePassword);
        }
        return true;
    }

    public static boolean hasPassword(boolean storedOnly, FileTransferConfig fileTransferConfig) {
        block6: {
            EnumSet<FileTransferConfig.PasswordState> allowedStates;
            if (fileTransferConfig.isAnonymous()) {
                return true;
            }
            EnumSet<FileTransferConfig.PasswordState> enumSet = allowedStates = storedOnly ? EnumSet.of(FileTransferConfig.PasswordState.Store) : EnumSet.of(FileTransferConfig.PasswordState.Store, FileTransferConfig.PasswordState.Specified);
            if (fileTransferConfig.isUseKeyPair()) {
                try {
                    if (allowedStates.contains((Object)fileTransferConfig.getPassphraseState()) || !KeyPair.load((JSch)new JSch(), (String)fileTransferConfig.getPrivateKeyFile()).isEncrypted()) {
                        return true;
                    }
                    break block6;
                }
                catch (JSchException e) {
                    LOG.error((Throwable)e);
                    return false;
                }
            }
            if (allowedStates.contains((Object)fileTransferConfig.getPasswordState())) {
                return true;
            }
        }
        return false;
    }

    private static class AuthPair {
        public String username;
        public String password;
        public boolean savePassword;

        private AuthPair() {
        }
    }
}

