/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.chromeConnector;

import com.intellij.chromeConnector.ChromeExtensionUtil;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.browserConnection.BrowserConnector;
import com.jetbrains.browserConnection.BrowserQualifier;
import com.jetbrains.browserConnection.WebBrowserConnectorBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

class ChromeConnector
extends BrowserConnector {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Browser Connection", NotificationDisplayType.STICKY_BALLOON, true);
    private final SingletonNotificationManager notification = new SingletonNotificationManager(NOTIFICATION_GROUP, NotificationType.INFORMATION, null);

    ChromeConnector() {
    }

    public boolean canHandle(@NotNull BrowserQualifier browserQualifier) {
        if (browserQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserQualifier", "com/intellij/chromeConnector/ChromeConnector", "canHandle"));
        }
        return !browserQualifier.equals((Object)BrowserQualifier.FIREFOX);
    }

    @NotNull
    public Promise<Void> ensureExtensionInstalled(@NotNull WebBrowser browser, @Nullable Project project) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/chromeConnector/ChromeConnector", "ensureExtensionInstalled"));
        }
        if (ChromeExtensionUtil.isChromeRunning(browser)) {
            this.notification.notify(WebBrowserConnectorBundle.message((String)"chrome.extension.required.title", (Object[])new Object[]{browser.getName()}), WebBrowserConnectorBundle.message((String)"chrome.extension.required", (Object[])new Object[]{browser.getName()}), project, (NotificationListener)new ChromeExtensionUtil.ExtLinkListener(browser, project));
        }
        Promise promise2 = Promise.DONE;
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/chromeConnector/ChromeConnector", "ensureExtensionInstalled"));
        }
        return promise2;
    }

    public void checkVersion(@NotNull WebBrowser browser, @Nullable String version, @Nullable Project project) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/chromeConnector/ChromeConnector", "checkVersion"));
        }
        if (StringUtil.compareVersionNumbers((String)version, (String)"0.5") < 0) {
            this.notification.notify(WebBrowserConnectorBundle.message((String)"chrome.update.extension.title", (Object[])new Object[0]), WebBrowserConnectorBundle.message((String)"chrome.update.extension.0.4", (Object[])new Object[0]), project, (NotificationListener)new ChromeExtensionUtil.ExtLinkListener(browser, project));
        }
    }
}

