/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.chromeConnector;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.util.SystemProperties;
import com.jetbrains.browserConnection.BrowserConnectionManager;
import com.jetbrains.browserConnection.BrowserQualifier;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChromeExtensionUtil {
    private static final Logger LOG = Logger.getInstance(ChromeExtensionUtil.class);
    @NonNls
    private static final String URL = "https://chrome.google.com/webstore/detail/jetbrains-ide-support/hmhgeddbohgjknpmjagkdomcpobmllji";

    private ChromeExtensionUtil() {
    }

    public static boolean isChromeRunning(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/chromeConnector/ChromeExtensionUtil", "isChromeRunning"));
        }
        if (SystemInfo.isUnix) {
            String[] files = SystemInfo.isMac ? new String[]{"/Library/Application Support/Google/Chrome", "/Library/Application Support/Google/Chrome Canary", "/Library/Application Support/Chromium", "/Library/Application Support/Yandex/YandexBrowser", "/Library/Application Support/com.operasoftware.Opera"} : new String[]{"/.config/google-chrome", "/.config/chromium"};
            for (String file : files) {
                if (!ChromeExtensionUtil.isChromeRunningUnderUnix(file)) continue;
                return true;
            }
        } else {
            String pattern;
            BrowserQualifier browserQualifier = BrowserConnectionManager.browserToQualifier((WebBrowser)browser);
            switch (browserQualifier) {
                case CHROME: 
                case DARTIUM: {
                    pattern = "chrome.exe";
                    break;
                }
                case YANDEX: {
                    pattern = "browser.exe";
                    break;
                }
                case OPERA: {
                    pattern = "opera.exe";
                    break;
                }
                default: {
                    return false;
                }
            }
            for (ProcessInfo process2 : OSProcessUtil.getProcessList()) {
                if (!process2.getCommandLine().contains(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isChromeRunningUnderUnix(String singletonLockFilename) {
        File file = new File(SystemProperties.getUserHome() + singletonLockFilename, "SingletonLock");
        if (!SystemInfo.isMac && FileSystemUtil.isSymLink((File)file)) {
            return true;
        }
        if (!file.exists()) {
            return false;
        }
        try {
            FileLock lock = null;
            RandomAccessFile in = new RandomAccessFile(file, "rw");
            try {
                lock = in.getChannel().tryLock();
                if (lock != null) return false;
                boolean bl = true;
                return bl;
            }
            catch (OverlappingFileLockException ignored) {
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    public static class ExtLinkListener
    extends BrowserHyperlinkListener
    implements NotificationListener {
        private final WebBrowser browser;
        @Nullable
        private final Project project;

        public ExtLinkListener(@NotNull WebBrowser browser, @Nullable Project project) {
            if (browser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/chromeConnector/ChromeExtensionUtil$ExtLinkListener", "<init>"));
            }
            this.browser = browser;
            this.project = project;
        }

        protected void hyperlinkActivated(HyperlinkEvent event) {
            if (StringUtil.isEmpty((String)event.getDescription())) {
                BrowserLauncher.getInstance().browse(ChromeExtensionUtil.URL, this.browser, this.project);
            } else {
                super.hyperlinkActivated(event);
            }
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/chromeConnector/ChromeExtensionUtil$ExtLinkListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/chromeConnector/ChromeExtensionUtil$ExtLinkListener", "hyperlinkUpdate"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.hyperlinkActivated(event);
            }
        }
    }
}

