/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nwjs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.jetbrains.javascript.debugger.execution.DebuggableProcessState;
import com.jetbrains.nwjs.NwjsProcessHandler;
import com.jetbrains.nwjs.NwjsProcessStateKt;
import com.jetbrains.nwjs.NwjsRemoteVmConnection;
import com.jetbrains.nwjs.NwjsRunConfiguration;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0016\u001a\u00020\u000fH\u0002J\f\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0014R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/nwjs/NwjsProcessState;", "Lcom/jetbrains/javascript/debugger/execution/DebuggableProcessState;", "Lcom/jetbrains/nwjs/NwjsRunConfiguration;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/jetbrains/nwjs/NwjsRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "programParametersList", "", "", "url", "Lcom/intellij/util/Url;", "vmConnection", "Lcom/jetbrains/debugger/wip/WipRemoteVmConnection;", "configureCommandLine", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "debugPort", "", "createProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "initProgramParameters", "prepareDebug", "Lorg/jetbrains/concurrency/Promise;", "ChromeConnector"})
public final class NwjsProcessState
extends DebuggableProcessState<NwjsRunConfiguration> {
    private Url url;
    private WipRemoteVmConnection vmConnection;
    private List<String> programParametersList;

    @NotNull
    protected Promise<?> prepareDebug() {
        this.initProgramParameters();
        String rawUrl = null;
        if (!UtilKt.isNullOrEmpty(this.programParametersList)) {
            List<String> list = this.programParametersList;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String param = iterator.next();
                if (StringsKt.startsWith$default((String)param, (String)"--remote-debugging-port=", (boolean)false, (int)2, null)) {
                    iterator.remove();
                    continue;
                }
                if (!StringsKt.startsWith$default((String)param, (String)"--rawUrl=", (boolean)false, (int)2, null)) continue;
                String string = param;
                int n = "--rawUrl=".length();
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                iterator.remove();
            }
        }
        if (rawUrl == null) {
            File file = new File(this.getInputPath());
            if (file.isDirectory()) {
                rawUrl = NwjsProcessStateKt.access$getMainUrlFromManifest(file);
            } else {
                if (file.isFile()) {
                    AsyncPromise callback = new AsyncPromise();
                    ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, file, callback, this.getEnvironment().getProject(), "Unpacking NW.js app..."){
                        final /* synthetic */ NwjsProcessState this$0;
                        final /* synthetic */ File $file;
                        final /* synthetic */ AsyncPromise $callback;

                        public void run(@NotNull ProgressIndicator indicator) {
                            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                            try {
                                File tempDirectory = FileUtil.createTempDirectory((String)"NW.js", (String)"idea");
                                ZipUtil.unzip((ProgressIndicator)indicator, (File)tempDirectory, (File)this.$file, (NullableFunction)null, (ZipUtil.ContentProcessor)null, (boolean)true);
                                File file = tempDirectory;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"tempDirectory");
                                String string = NwjsProcessStateKt.access$getMainUrlFromManifest(file);
                                String string2 = tempDirectory.getPath();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tempDirectory.path");
                                NwjsProcessState.access$setUrl$p(this.this$0, NwjsProcessStateKt.access$parseRawUrl(string, string2));
                            }
                            catch (Exception e) {
                                this.$callback.setError((Throwable)e);
                                NwjsProcessStateKt.access$getLOG$p().error("Cannot unpack packaged app " + this.$file.getPath(), (Throwable)e);
                            }
                        }

                        public void onCancel() {
                            this.$callback.setError("canceled");
                        }

                        public void onSuccess() {
                            this.$callback.setResult(null);
                        }
                        {
                            this.this$0 = $outer;
                            this.$file = $captured_local_variable$1;
                            this.$callback = $captured_local_variable$2;
                            super($super_call_param$3, $super_call_param$4);
                        }
                    });
                    return (Promise)callback;
                }
                if (!file.exists()) {
                    throw (Throwable)new ExecutionException("NW.js app doesn't exist " + file.getPath());
                }
                throw (Throwable)new ExecutionException("Unknown file " + file.getPath());
            }
        }
        this.url = NwjsProcessStateKt.access$parseRawUrl(rawUrl, this.getInputPath());
        return Promises.resolvedPromise();
    }

    protected void configureCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        if (debugPort == -1) {
            this.initProgramParameters();
        } else {
            NwjsProcessStateKt.access$getLOG$p().assertTrue(this.url != null);
            commandLine.addParameter("--remote-debugging-port=" + debugPort);
            if (SystemProperties.getBooleanProperty((String)"nodewebkit.use.bootstrap", (boolean)false)) {
                String string = "<!DOCTYPE html><title>Loading " + this.url + "</title>";
                Charset charset = null;
                boolean bl = true;
                Object var7_6 = null;
                Base64.Encoder encoder = Base64.getEncoder();
                StringBuilder stringBuilder = new StringBuilder().append("data:text/html;base64,");
                if (var7_6 != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
                }
                if (bl & true) {
                    charset = Charsets.UTF_8;
                }
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                String bootstrapUrl = stringBuilder.append(encoder.encodeToString(byArray2)).toString();
                commandLine.addParameter("--url=" + bootstrapUrl);
                this.vmConnection = new WipRemoteVmConnection(this.url, bootstrapUrl, null, 4, null);
            } else {
                this.vmConnection = new NwjsRemoteVmConnection();
            }
        }
        List<String> list = this.programParametersList;
        if (list != null) {
            List<String> list2 = list;
            List<String> it = list2;
            commandLine.addParameters(it);
        }
        this.addInputPathArg(commandLine);
    }

    private final void initProgramParameters() {
        Object object;
        block3: {
            block2: {
                NwjsProcessState nwjsProcessState = this;
                object = ((NwjsRunConfiguration)this.getConfiguration()).getProgramParameters();
                if (object == null) break block2;
                String string = object;
                NwjsProcessState nwjsProcessState2 = nwjsProcessState;
                String it = string;
                List list = ParametersListUtil.parse((String)it);
                nwjsProcessState = nwjsProcessState2;
                object = list;
                if (object != null) break block3;
            }
            object = null;
        }
        nwjsProcessState.programParametersList = object;
    }

    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        if (debugPort == -1) {
            return super.createProcessHandler(commandLine, debugPort);
        }
        WipRemoteVmConnection wipRemoteVmConnection = this.vmConnection;
        if (wipRemoteVmConnection == null) {
            Intrinsics.throwNpe();
        }
        NwjsProcessHandler handler2 = new NwjsProcessHandler(commandLine, wipRemoteVmConnection);
        return (ProcessHandler)handler2;
    }

    public NwjsProcessState(@NotNull NwjsRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        super((DebuggableProcessRunConfiguration)configuration, environment);
    }

    @Nullable
    public static final /* synthetic */ Url access$getUrl$p(NwjsProcessState $this) {
        return $this.url;
    }

    public static final /* synthetic */ void access$setUrl$p(NwjsProcessState $this, @Nullable Url url) {
        $this.url = url;
    }
}

