/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptTypedHandler
extends TypedHandlerDelegate {
    private boolean checkAutoPopupHandled;

    private static boolean isSelectionInsideDoubleQuotedString(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/coffeescript/editor/CoffeeScriptTypedHandler", "isSelectionInsideDoubleQuotedString"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/coffeescript/editor/CoffeeScriptTypedHandler", "isSelectionInsideDoubleQuotedString"));
        }
        if (editor.getSelectionModel().hasSelection() && (element = file.findElementAt(editor.getSelectionModel().getSelectionStart())) != null && element.getNode().getElementType() == CoffeeScriptTokenTypes.STRING_LITERAL && element.getText().startsWith("\"")) {
            SelectionModel selectionModel = editor.getSelectionModel();
            return element.getTextRange().contains(new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
        }
        return false;
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (this.checkAutoPopupHandled) {
            this.checkAutoPopupHandled = false;
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.beforeCharTyped(c, project, editor, file, fileType);
    }

    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        if (charTyped == '#' && CoffeeScriptUtil.isCoffeeScriptContent((PsiElement)file) && CoffeeScriptTypedHandler.isSelectionInsideDoubleQuotedString(editor, file)) {
            int start = editor.getSelectionModel().getSelectionStart();
            int end = editor.getSelectionModel().getSelectionEnd();
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(start);
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"#{");
            editor.getCaretModel().moveToOffset(end + 2);
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"}");
            this.checkAutoPopupHandled = true;
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.checkAutoPopup(charTyped, project, editor, file);
    }
}

