/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class GroovyFix
implements LocalQuickFix {
    public static final GroovyFix EMPTY_FIX = new GroovyFix(){

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
        }

        @NotNull
        public String getName() {
            throw new UnsupportedOperationException();
        }
    };
    public static final GroovyFix[] EMPTY_ARRAY = new GroovyFix[0];

    @NotNull
    public String getFamilyName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/GroovyFix", "getFamilyName"));
        }
        return "";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/GroovyFix", "applyFix"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/GroovyFix", "applyFix"));
        }
        PsiElement problemElement = descriptor2.getPsiElement();
        if (problemElement == null || !problemElement.isValid()) {
            return;
        }
        if (GroovyFix.isQuickFixOnReadOnlyFile(problemElement)) {
            return;
        }
        try {
            this.doFix(project, descriptor2);
        }
        catch (IncorrectOperationException e) {
            Class<?> aClass = this.getClass();
            String className = aClass.getName();
            Logger logger = Logger.getInstance((String)className);
            logger.error((Throwable)e);
        }
    }

    protected abstract void doFix(Project var1, ProblemDescriptor var2) throws IncorrectOperationException;

    protected static boolean isQuickFixOnReadOnlyFile(PsiElement problemElement) {
        return !FileModificationService.getInstance().preparePsiElementForWrite(problemElement);
    }

    protected static void replaceExpression(GrExpression expression, String newExpression) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
        GrExpression newCall = factory.createExpressionFromText(newExpression);
        expression.replaceWithExpression(newCall, true);
    }

    protected static void replaceStatement(GrStatement statement, String newStatement) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(statement.getProject());
        GrStatement newCall = (GrStatement)factory.createTopElementFromText(newStatement);
        statement.replaceWithStatement(newCall);
    }

    protected static void replaceStatement(GrStatement oldStatement, GrStatement newStatement) throws IncorrectOperationException {
        if (newStatement instanceof GrBlockStatement) {
            GrBlockStatement blockStatement = (GrBlockStatement)newStatement;
            GrOpenBlock openBlock = blockStatement.getBlock();
            GrStatement[] statements = openBlock.getStatements();
            if (statements.length == 0) {
                oldStatement.removeStatement();
            } else {
                PsiElement parent = oldStatement.getParent();
                if (parent instanceof GrStatementOwner) {
                    GrStatementOwner statementOwner = (GrStatementOwner)parent;
                    for (GrStatement statement : statements) {
                        statementOwner.addStatementBefore(statement, oldStatement);
                    }
                    oldStatement.removeStatement();
                } else if (parent instanceof GrControlStatement) {
                    oldStatement.replace(newStatement);
                }
            }
        } else {
            oldStatement.replaceWithStatement(newStatement);
        }
    }
}

