/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.bugs.AddMethodFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class AddClassToExtendsFix
extends GroovyFix {
    private final GrTypeDefinition myPsiClass;
    private final String myInterfaceName;

    public AddClassToExtendsFix(GrTypeDefinition psiClass, String interfaceName) {
        this.myPsiClass = psiClass;
        this.myInterfaceName = interfaceName;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
        PsiTypeParameter[] typeParameters;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        PsiClass comparable = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Comparable", this.myPsiClass.getResolveScope());
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        boolean addTypeParam = false;
        if (comparable != null && (typeParameters = comparable.getTypeParameters()).length == 1) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiTypeParameter[] classParams = this.myPsiClass.getTypeParameters();
            PsiSubstitutor innerSubstitutor = PsiSubstitutor.EMPTY;
            for (PsiTypeParameter classParam : classParams) {
                innerSubstitutor = innerSubstitutor.put(classParam, (PsiType)elementFactory.createType((PsiClass)classParam));
            }
            substitutor = substitutor.put(typeParameters[0], (PsiType)elementFactory.createType((PsiClass)this.myPsiClass, innerSubstitutor));
            addTypeParam = true;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)this.myPsiClass, (String)"java.lang.Comparable")) {
            GroovyPsiElement anchor;
            GrReferenceList list;
            if (this.myPsiClass.isInterface()) {
                list = this.myPsiClass.getExtendsClause();
                if (list == null) {
                    list = factory.createExtendsClause();
                    anchor = this.myPsiClass.getImplementsClause();
                    if (anchor == null) {
                        anchor = this.myPsiClass.getBody();
                    }
                    if (anchor == null) {
                        return;
                    }
                    list = (GrReferenceList)this.myPsiClass.addBefore(list, anchor);
                    this.myPsiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor.getNode());
                    this.myPsiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", list.getNode());
                }
            } else {
                list = this.myPsiClass.getImplementsClause();
                if (list == null) {
                    list = factory.createImplementsClause();
                    anchor = this.myPsiClass.getBody();
                    if (anchor == null) {
                        return;
                    }
                    list = (GrReferenceList)this.myPsiClass.addBefore(list, anchor);
                    this.myPsiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", list.getNode());
                    this.myPsiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor.getNode());
                }
            }
            GrCodeReferenceElement _ref = factory.createReferenceElementFromText(this.myInterfaceName + (addTypeParam ? "<" + AddMethodFix.generateTypeText(this.myPsiClass) + ">" : ""));
            GrCodeReferenceElement ref = (GrCodeReferenceElement)list.add(_ref);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)ref);
        }
        if (comparable != null && !this.myPsiClass.isInterface()) {
            PsiMethod baseMethod = comparable.getMethods()[0];
            OverrideImplementUtil.overrideOrImplement((PsiClass)this.myPsiClass, (PsiMethod)baseMethod);
        }
    }

    @NotNull
    public String getName() {
        String string = GroovyInspectionBundle.message("implement.class", this.myInterfaceName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/AddClassToExtendsFix", "getName"));
        }
        return string;
    }
}

