/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public class GroovyAccessibilityInspection
extends GroovySuppressableInspectionTool {
    private static final String SHORT_NAME = "GroovyAccessibility";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyAccessibilityInspection", "getGroupDisplayName"));
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("access.to.inaccessible.element", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyAccessibilityInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public static boolean isInspectionEnabled(GroovyFileBase file, Project project) {
        return GroovyAccessibilityInspection.getInspectionProfile(project).isToolEnabled(GroovyAccessibilityInspection.findDisplayKey(), (PsiElement)file);
    }

    public static GroovyAccessibilityInspection getInstance(GroovyFileBase file, Project project) {
        return (GroovyAccessibilityInspection)GroovyAccessibilityInspection.getInspectionProfile(project).getUnwrappedTool(SHORT_NAME, (PsiElement)file);
    }

    public static HighlightDisplayKey findDisplayKey() {
        return HighlightDisplayKey.find((String)SHORT_NAME);
    }

    public static HighlightDisplayLevel getHighlightDisplayLevel(Project project, GrReferenceElement ref) {
        return GroovyAccessibilityInspection.getInspectionProfile(project).getErrorLevel(GroovyAccessibilityInspection.findDisplayKey(), (PsiElement)ref);
    }

    @NotNull
    private static InspectionProfile getInspectionProfile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyAccessibilityInspection", "getInspectionProfile"));
        }
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        if (inspectionProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyAccessibilityInspection", "getInspectionProfile"));
        }
        return inspectionProfile;
    }

    public static boolean isSuppressed(PsiElement ref) {
        return GroovyAccessibilityInspection.isElementToolSuppressedIn(ref, SHORT_NAME);
    }
}

