/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyConditionalWithIdenticalBranchesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getDisplayName() {
        if ("Conditional expression with identical branches" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection", "getDisplayName"));
        }
        return "Conditional expression with identical branches";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection", "getGroupDisplayName"));
        }
        return "Control Flow";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Conditional expression with identical branches #loc";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection", "buildFix"));
        }
        return new CollapseConditionalFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(GrConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            GrExpression thenBranch = expression.getThenBranch();
            GrExpression elseBranch = expression.getElseBranch();
            if (thenBranch == null || elseBranch == null) {
                return;
            }
            if (EquivalenceChecker.expressionsAreEquivalent(thenBranch, elseBranch)) {
                this.registerStatementError(expression, new Object[0]);
            }
        }
    }

    private static class CollapseConditionalFix
    extends GroovyFix {
        private CollapseConditionalFix() {
        }

        @NotNull
        public String getName() {
            if ("Collapse conditional expression" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection$CollapseConditionalFix", "getName"));
            }
            return "Collapse conditional expression";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof GrConditionalExpression)) {
                return;
            }
            GrConditionalExpression expression = (GrConditionalExpression)element;
            GrExpression thenBranch = expression.getThenBranch();
            CollapseConditionalFix.replaceExpression(expression, thenBranch.getText());
        }
    }
}

