/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;

public class GroovyUnnecessaryContinueInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection", "getGroupDisplayName"));
        }
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unnecessary 'continue' statement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection", "getDisplayName"));
        }
        return "Unnecessary 'continue' statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref is unnecessary as the last statement in a loop #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection", "buildVisitor"));
        }
        return visitor;
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection", "buildFix"));
        }
        return new UnnecessaryContinueFix();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitContinueStatement(GrContinueStatement continueStatement) {
            super.visitContinueStatement(continueStatement);
            if (continueStatement.getContainingFile().getViewProvider() instanceof TemplateLanguageFileViewProvider) {
                return;
            }
            GrStatement continuedStatement = continueStatement.findTargetStatement();
            if (continuedStatement == null) {
                return;
            }
            if (!(continuedStatement instanceof GrLoopStatement)) {
                return;
            }
            GrStatement body = ((GrLoopStatement)continuedStatement).getBody();
            if (body == null) {
                return;
            }
            if (body instanceof GrBlockStatement && ControlFlowUtils.blockCompletesWithStatement((GrBlockStatement)body, continueStatement) || !(body instanceof GrBlockStatement) && ControlFlowUtils.statementCompletesWithStatement(body, continueStatement)) {
                this.registerStatementError(continueStatement, new Object[0]);
            }
        }
    }

    private static class UnnecessaryContinueFix
    extends GroovyFix {
        private UnnecessaryContinueFix() {
        }

        @NotNull
        public String getName() {
            if ("Remove unnecessary continue" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection$UnnecessaryContinueFix", "getName"));
            }
            return "Remove unnecessary continue";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement continueKeywordElement = descriptor2.getPsiElement();
            GrContinueStatement continueStatement = (GrContinueStatement)continueKeywordElement.getParent();
            assert (continueStatement != null);
            continueStatement.removeStatement();
        }
    }
}

