/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;

public class AnnotatedContextFilter
implements ContextFilter {
    private final String myAnnoQName;

    public AnnotatedContextFilter(String annoQName) {
        this.myAnnoQName = annoQName;
    }

    @Override
    public boolean isApplicable(GroovyClassDescriptor descriptor2, ProcessingContext ctx) {
        if (AnnotatedContextFilter.getPossibleAnnotations(descriptor2.getPlaceFile()).get(StringUtil.getShortName((String)this.myAnnoQName)) != Boolean.TRUE) {
            return false;
        }
        return AnnotatedContextFilter.findContextAnnotation(descriptor2.getPlace(), this.myAnnoQName) != null;
    }

    private static Map<String, Boolean> getPossibleAnnotations(PsiFile file) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            ConcurrentFactoryMap result = StringUtil.contains((CharSequence)file.getViewProvider().getContents(), (CharSequence)"@") ? ConcurrentFactoryMap.createMap(anno -> AnnotatedContextFilter.containsString(anno, file)) : Collections.emptyMap();
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{file});
        });
    }

    @NotNull
    private static Boolean containsString(String anno, PsiFile file) {
        if (file.getVirtualFile() == null) {
            Boolean bl = StringUtil.contains((CharSequence)file.getViewProvider().getContents(), (CharSequence)anno);
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/toplevel/AnnotatedContextFilter", "containsString"));
            }
            return bl;
        }
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)file);
        Boolean bl = !FileBasedIndex.getInstance().getContainingFiles(IdIndex.NAME, (Object)new IdIndexEntry(anno, true), scope).isEmpty();
        if (bl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/toplevel/AnnotatedContextFilter", "containsString"));
        }
        return bl;
    }

    @Nullable
    public static PsiAnnotation findContextAnnotation(@NotNull PsiElement context, String annoQName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/dsl/toplevel/AnnotatedContextFilter", "findContextAnnotation"));
        }
        for (PsiElement current = context; current != null; current = current.getContext()) {
            GrPackageDefinition packageDefinition;
            if (current instanceof PsiModifierListOwner) {
                PsiAnnotation annotation;
                if (current instanceof GrVariableDeclaration || (annotation = AnnotatedContextFilter.findAnnotation(((PsiModifierListOwner)current).getModifierList(), annoQName)) == null) continue;
                return annotation;
            }
            if (!(current instanceof PsiFile)) continue;
            if (current instanceof GroovyFile && (packageDefinition = ((GroovyFile)current).getPackageDefinition()) != null) {
                return AnnotatedContextFilter.findAnnotation(packageDefinition.getAnnotationList(), annoQName);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotation(PsiModifierList modifierList, String annoQName) {
        return modifierList != null ? modifierList.findAnnotation(annoQName) : null;
    }
}

