/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.toplevel.packaging;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrPackageDefinitionImpl
extends GrStubElementBase<GrPackageDefinitionStub>
implements GrPackageDefinition,
StubBasedPsiElement<GrPackageDefinitionStub> {
    public GrPackageDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/packaging/GrPackageDefinitionImpl", "<init>"));
        }
        super(node);
    }

    public GrPackageDefinitionImpl(@NotNull GrPackageDefinitionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/packaging/GrPackageDefinitionImpl", "<init>"));
        }
        super(stub, GroovyElementTypes.PACKAGE_DEFINITION);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitPackageDefinition(this);
    }

    public String toString() {
        return "Package definition";
    }

    @Override
    public String getPackageName() {
        GrPackageDefinitionStub stub = (GrPackageDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getPackageName();
        }
        GrCodeReferenceElement ref = this.getPackageReference();
        if (ref == null) {
            return "";
        }
        return PsiUtil.getQualifiedReferenceText(ref);
    }

    @Override
    public GrCodeReferenceElement getPackageReference() {
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    @NotNull
    public GrModifierList getAnnotationList() {
        GrModifierList grModifierList = (GrModifierList)this.getStubOrPsiChild(GroovyElementTypes.MODIFIERS);
        if (grModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/packaging/GrPackageDefinitionImpl", "getAnnotationList"));
        }
        return grModifierList;
    }

    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/packaging/GrPackageDefinitionImpl", "hasModifierProperty"));
        }
        PsiModifierList list = this.getModifierList();
        return list != null && list.hasExplicitModifier(name);
    }
}

