/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ExtendClassImpl;
import com.intellij.util.xml.PsiClassConverter;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.TagValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.ExtensionPoints;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.impl.IdeaPluginConverter;
import org.jetbrains.idea.devkit.dom.impl.LanguageResolvingConverter;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;

public class ExtensionDomExtender
extends DomExtender<Extensions> {
    private static final PsiClassConverter CLASS_CONVERTER = new PluginPsiClassConverter();
    private static final Converter LANGUAGE_CONVERTER = new LanguageResolvingConverter();
    private static final DomExtender EXTENSION_EXTENDER = new DomExtender(){

        public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
            if (domElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$1", "registerExtensions"));
            }
            if (registrar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$1", "registerExtensions"));
            }
            ExtensionPoint extensionPoint = (ExtensionPoint)domElement.getChildDescription().getDomDeclaration();
            assert (extensionPoint != null);
            String interfaceName = extensionPoint.getInterface().getStringValue();
            if (interfaceName != null) {
                DomExtension implementationAttribute = registrar.registerGenericAttributeValueChildExtension(new XmlName("implementation"), PsiClass.class).setConverter((Converter)CLASS_CONVERTER).addCustomAnnotation((Annotation)((Object)new MyExtendClass(interfaceName))).addCustomAnnotation((Annotation)((Object)new MyRequired()));
                PsiClass interfaceClass = (PsiClass)extensionPoint.getInterface().getValue();
                if (interfaceClass != null) {
                    implementationAttribute.setDeclaringElement((PsiElement)interfaceClass);
                } else {
                    implementationAttribute.setDeclaringElement((DomElement)extensionPoint);
                }
                ExtensionDomExtender.registerXmlb(registrar, interfaceClass, Collections.emptyList());
            } else {
                PsiClass beanClass = (PsiClass)extensionPoint.getBeanClass().getValue();
                ExtensionDomExtender.registerXmlb(registrar, beanClass, extensionPoint.getWithElements());
            }
        }
    };

    private static Set<IdeaPlugin> getVisiblePlugins(IdeaPlugin ideaPlugin) {
        HashSet result = ContainerUtil.newHashSet();
        MultiMap<String, IdeaPlugin> byId = ExtensionDomExtender.getPluginMap(ideaPlugin.getManager().getProject());
        ExtensionDomExtender.collectDependencies(ideaPlugin, result, byId);
        result.addAll(byId.get(null));
        return result;
    }

    private static MultiMap<String, IdeaPlugin> getPluginMap(Project project) {
        LinkedMultiMap byId = new LinkedMultiMap();
        for (IdeaPlugin each : IdeaPluginConverter.getAllPlugins(project)) {
            byId.putValue((Object)each.getPluginId(), (Object)each);
        }
        return byId;
    }

    private static void collectDependencies(IdeaPlugin ideaPlugin, Set<IdeaPlugin> result, MultiMap<String, IdeaPlugin> byId) {
        if (!result.add(ideaPlugin)) {
            return;
        }
        for (String id : ExtensionDomExtender.getDependencies(ideaPlugin)) {
            for (IdeaPlugin dep : byId.get((Object)id)) {
                ExtensionDomExtender.collectDependencies(dep, result, byId);
            }
        }
    }

    private static void registerExtensionPoint(DomExtensionsRegistrar registrar, ExtensionPoint extensionPoint, String epPrefix, @Nullable String pluginId) {
        String epName = extensionPoint.getName().getStringValue();
        if (epName != null && StringUtil.isNotEmpty((String)pluginId)) {
            epName = pluginId + "." + epName;
        }
        if (epName == null) {
            epName = extensionPoint.getQualifiedName().getStringValue();
        }
        if (epName == null) {
            return;
        }
        if (!epName.startsWith(epPrefix)) {
            return;
        }
        DomExtension domExtension = registrar.registerCollectionChildrenExtension(new XmlName(epName.substring(epPrefix.length())), Extension.class);
        domExtension.setDeclaringElement((DomElement)extensionPoint);
        domExtension.addExtender(EXTENSION_EXTENDER);
    }

    private static void registerXmlb(DomExtensionsRegistrar registrar, @Nullable PsiClass beanClass, @NotNull List<With> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender", "registerXmlb"));
        }
        if (beanClass == null) {
            return;
        }
        for (PsiField field : beanClass.getAllFields()) {
            ExtensionDomExtender.registerField(registrar, field, ExtensionDomExtender.findWithElement(elements, field));
        }
    }

    @Nullable
    public static With findWithElement(List<With> elements, PsiField field) {
        for (With element : elements) {
            if (!Comparing.equal((String)field.getName(), (String)element.getAttribute().getStringValue())) continue;
            return element;
        }
        return null;
    }

    private static void registerField(DomExtensionsRegistrar registrar, final @NotNull PsiField field, With withElement) {
        String tagName;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender", "registerField"));
        }
        PsiMethod getter = PropertyUtil.findGetterForField((PsiField)field);
        PsiMethod setter = PropertyUtil.findSetterForField((PsiField)field);
        if (!(field.hasModifierProperty("public") || getter != null && setter != null)) {
            return;
        }
        String fieldName = field.getName();
        final PsiConstantEvaluationHelper evalHelper = JavaPsiFacade.getInstance((Project)field.getProject()).getConstantEvaluationHelper();
        PsiAnnotation attrAnno = ExtensionDomExtender.findAnnotation(Attribute.class, new PsiMember[]{field, getter, setter});
        if (attrAnno != null) {
            String attrName = ExtensionDomExtender.getStringAttribute(attrAnno, "value", evalHelper);
            if (attrName != null) {
                Class clazz = String.class;
                if (withElement != null || ExtensionDomExtender.isClassField(fieldName)) {
                    clazz = PsiClass.class;
                } else if (PsiType.BOOLEAN.equals((Object)field.getType())) {
                    clazz = Boolean.class;
                }
                DomExtension extension = registrar.registerGenericAttributeValueChildExtension(new XmlName(attrName), clazz).setDeclaringElement((PsiElement)field);
                ExtensionDomExtender.markAsClass(extension, fieldName, withElement);
                if (clazz.equals(String.class)) {
                    ExtensionDomExtender.markAsLanguage(extension, fieldName);
                }
            }
            return;
        }
        PsiAnnotation tagAnno = ExtensionDomExtender.findAnnotation(Tag.class, new PsiMember[]{field, getter, setter});
        PsiAnnotation propAnno = ExtensionDomExtender.findAnnotation(Property.class, new PsiMember[]{field, getter, setter});
        final PsiAnnotation absColAnno = ExtensionDomExtender.findAnnotation(AbstractCollection.class, new PsiMember[]{field, getter, setter});
        String string = tagAnno != null ? ExtensionDomExtender.getStringAttribute(tagAnno, "value", evalHelper) : (tagName = propAnno != null && ExtensionDomExtender.getBooleanAttribute(propAnno, "surroundWithTag", evalHelper) ? "option" : null);
        if (tagName != null) {
            if (absColAnno == null) {
                DomExtension extension = registrar.registerFixedNumberChildExtension(new XmlName(tagName), SimpleTagValue.class).setDeclaringElement((PsiElement)field);
                ExtensionDomExtender.markAsClass(extension, fieldName, withElement);
            } else {
                registrar.registerFixedNumberChildExtension(new XmlName(tagName), DomElement.class).addExtender(new DomExtender(){

                    public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                        if (domElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$2", "registerExtensions"));
                        }
                        if (registrar == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$2", "registerExtensions"));
                        }
                        ExtensionDomExtender.registerCollectionBinding(field.getType(), registrar, absColAnno, evalHelper);
                    }
                });
            }
        } else if (absColAnno != null) {
            ExtensionDomExtender.registerCollectionBinding(field.getType(), registrar, absColAnno, evalHelper);
        }
    }

    private static void markAsLanguage(DomExtension extension, String fieldName) {
        if ("language".equals(fieldName)) {
            extension.setConverter(LANGUAGE_CONVERTER);
        }
    }

    private static void markAsClass(DomExtension extension, String fieldName, @Nullable With withElement) {
        if (withElement != null) {
            final String withClassName = withElement.getImplements().getStringValue();
            extension.addCustomAnnotation((Annotation)new ExtendClassImpl(){

                public String value() {
                    return withClassName;
                }
            });
        }
        if (withElement != null || ExtensionDomExtender.isClassField(fieldName)) {
            extension.setConverter((Converter)CLASS_CONVERTER);
        }
    }

    public static boolean isClassField(String fieldName) {
        return fieldName.endsWith("Class") && !fieldName.equals("forClass") || fieldName.equals("implementation") || fieldName.equals("serviceInterface") || fieldName.equals("serviceImplementation");
    }

    @Nullable
    static PsiAnnotation findAnnotation(Class<?> annotationClass, PsiMember ... members) {
        for (PsiMember member : members) {
            PsiAnnotation annotation;
            PsiModifierList modifierList;
            if (member == null || (modifierList = member.getModifierList()) == null || (annotation = modifierList.findAnnotation(annotationClass.getName())) == null) continue;
            return annotation;
        }
        return null;
    }

    private static void registerCollectionBinding(PsiType type, DomExtensionsRegistrar registrar, PsiAnnotation anno, PsiConstantEvaluationHelper evalHelper) {
        boolean surroundWithTag = ExtensionDomExtender.getBooleanAttribute(anno, "surroundWithTag", evalHelper);
        if (surroundWithTag) {
            return;
        }
        String tagName = ExtensionDomExtender.getStringAttribute(anno, "elementTag", evalHelper);
        final String attrName = ExtensionDomExtender.getStringAttribute(anno, "elementValueAttribute", evalHelper);
        PsiType elementType = ExtensionDomExtender.getElementType(type);
        if (elementType == null || TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)elementType) || "java.lang.String".equals(elementType.getCanonicalText()) || TypeConversionUtil.isEnumType((PsiType)elementType)) {
            if (tagName != null && attrName == null) {
                registrar.registerCollectionChildrenExtension(new XmlName(tagName), SimpleTagValue.class);
            } else if (tagName != null) {
                registrar.registerCollectionChildrenExtension(new XmlName(tagName), DomElement.class).addExtender(new DomExtender(){

                    public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                        if (domElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$4", "registerExtensions"));
                        }
                        if (registrar == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$4", "registerExtensions"));
                        }
                        registrar.registerGenericAttributeValueChildExtension(new XmlName(attrName), String.class);
                    }
                });
            }
        } else {
            final PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)elementType);
            if (psiClass != null) {
                String classTagName;
                PsiModifierList modifierList = psiClass.getModifierList();
                PsiAnnotation tagAnno = modifierList == null ? null : modifierList.findAnnotation(Tag.class.getName());
                String string = classTagName = tagAnno == null ? psiClass.getName() : ExtensionDomExtender.getStringAttribute(tagAnno, "value", evalHelper);
                if (classTagName != null) {
                    registrar.registerCollectionChildrenExtension(new XmlName(classTagName), DomElement.class).addExtender(new DomExtender(){

                        public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                            if (domElement == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$5", "registerExtensions"));
                            }
                            if (registrar == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender$5", "registerExtensions"));
                            }
                            ExtensionDomExtender.registerXmlb(registrar, psiClass, Collections.emptyList());
                        }
                    });
                }
            }
        }
    }

    @Nullable
    static String getStringAttribute(PsiAnnotation annotation, String name, PsiConstantEvaluationHelper evalHelper) {
        String value = ExtensionDomExtender.getAttributeValue(annotation, name);
        if (value != null) {
            return value;
        }
        Object o = evalHelper.computeConstantExpression((PsiElement)annotation.findAttributeValue(name), false);
        return o instanceof String && StringUtil.isNotEmpty((String)((String)o)) ? (String)o : null;
    }

    private static boolean getBooleanAttribute(PsiAnnotation annotation, String name, PsiConstantEvaluationHelper evalHelper) {
        String value = ExtensionDomExtender.getAttributeValue(annotation, name);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        Object o = evalHelper.computeConstantExpression((PsiElement)annotation.findAttributeValue(name), false);
        return o instanceof Boolean && (Boolean)o != false;
    }

    @Nullable
    private static String getAttributeValue(PsiAnnotation annotation, String name) {
        for (PsiNameValuePair attribute : annotation.getParameterList().getAttributes()) {
            if (!name.equals(attribute.getName())) continue;
            return attribute.getLiteralValue();
        }
        return null;
    }

    @Nullable
    public static PsiType getElementType(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            return ((PsiArrayType)psiType).getComponentType();
        }
        if (psiType instanceof PsiClassType) {
            PsiType[] types = ((PsiClassType)psiType).getParameters();
            return types.length == 1 ? types[0] : null;
        }
        return null;
    }

    public static Collection<String> getDependencies(IdeaPlugin ideaPlugin) {
        PsiFile psiFile;
        VirtualFile mainPluginXml;
        String fileName;
        VirtualFile file;
        HashSet<String> result = new HashSet<String>();
        result.add("com.intellij");
        for (Dependency dependency : ideaPlugin.getDependencies()) {
            ContainerUtil.addIfNotNull(result, (Object)dependency.getStringValue());
        }
        if (ideaPlugin.getPluginId() == null && (file = DomUtil.getFile((DomElement)ideaPlugin).getOriginalFile().getVirtualFile()) != null && !"plugin.xml".equals(fileName = file.getName()) && (mainPluginXml = file.findFileByRelativePath("../plugin.xml")) != null && (psiFile = PsiManager.getInstance((Project)ideaPlugin.getManager().getProject()).findFile(mainPluginXml)) instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile;
            DomFileElement fileElement = ideaPlugin.getManager().getFileElement(xmlFile, IdeaPlugin.class);
            if (fileElement != null) {
                IdeaPlugin mainPlugin = (IdeaPlugin)fileElement.getRootElement();
                ContainerUtil.addIfNotNull(result, (Object)mainPlugin.getPluginId());
                for (Dependency dependency : mainPlugin.getDependencies()) {
                    ContainerUtil.addIfNotNull(result, (Object)dependency.getStringValue());
                }
            }
        }
        return result;
    }

    public void registerExtensions(@NotNull Extensions extensions, @NotNull DomExtensionsRegistrar registrar) {
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender", "registerExtensions"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/dom/impl/ExtensionDomExtender", "registerExtensions"));
        }
        XmlElement xmlElement = extensions.getXmlElement();
        if (xmlElement == null) {
            return;
        }
        IdeaPlugin ideaPlugin = (IdeaPlugin)extensions.getParentOfType(IdeaPlugin.class, true);
        if (ideaPlugin == null) {
            return;
        }
        String epPrefix = extensions.getEpPrefix();
        for (IdeaPlugin plugin : ExtensionDomExtender.getVisiblePlugins(ideaPlugin)) {
            String pluginId = StringUtil.notNullize((String)plugin.getPluginId(), (String)"com.intellij");
            for (ExtensionPoints points : plugin.getExtensionPoints()) {
                for (ExtensionPoint point : points.getExtensionPoints()) {
                    ExtensionDomExtender.registerExtensionPoint(registrar, point, epPrefix, pluginId);
                }
            }
        }
    }

    public boolean supportsStubs() {
        return false;
    }

    private static class MyExtendClass
    extends ExtendClassImpl {
        private final String myInterfaceName;

        private MyExtendClass(String interfaceName) {
            this.myInterfaceName = interfaceName;
        }

        public boolean allowAbstract() {
            return false;
        }

        public boolean allowInterface() {
            return false;
        }

        public boolean allowEnum() {
            return false;
        }

        public String value() {
            return this.myInterfaceName;
        }
    }

    private static class MyRequired
    implements Required {
        private MyRequired() {
        }

        public boolean value() {
            return true;
        }

        public boolean nonEmpty() {
            return true;
        }

        public boolean identifier() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Required.class;
        }
    }

    static interface SimpleTagValue
    extends DomElement {
        @TagValue
        public String getTagValue();
    }
}

