/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.graph.fileEditor;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.facet.ui.StrutsFileSet;
import com.intellij.struts2.graph.fileEditor.Struts2GraphFileEditor;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import com.intellij.util.xml.ui.PerspectiveFileEditorProvider;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Struts2GraphFileEditorProvider
extends PerspectiveFileEditorProvider {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts2/graph/fileEditor/Struts2GraphFileEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/struts2/graph/fileEditor/Struts2GraphFileEditorProvider", "accept"));
        }
        if (!file.isValid()) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        if (psiFile instanceof JspFile) {
            return false;
        }
        if (!StrutsManager.getInstance(project).isStruts2ConfigFile((XmlFile)psiFile)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return false;
        }
        Set<StrutsFileSet> fileSets = StrutsManager.getInstance(project).getAllConfigFileSets(module);
        for (StrutsFileSet fileSet : fileSets) {
            if (!fileSet.hasFile(file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PerspectiveFileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts2/graph/fileEditor/Struts2GraphFileEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/struts2/graph/fileEditor/Struts2GraphFileEditorProvider", "createEditor"));
        }
        Struts2GraphFileEditor struts2GraphFileEditor = new Struts2GraphFileEditor(project, file);
        if (struts2GraphFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/graph/fileEditor/Struts2GraphFileEditorProvider", "createEditor"));
        }
        return struts2GraphFileEditor;
    }

    public boolean isDumbAware() {
        return false;
    }

    public double getWeight() {
        return 0.0;
    }
}

