/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.reference.jsp;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class NamespaceReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/reference/jsp/NamespaceReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts2/reference/jsp/NamespaceReferenceProvider", "getReferencesByElement"));
        }
        StrutsManager strutsManager = StrutsManager.getInstance(psiElement.getProject());
        StrutsModel strutsModel = strutsManager.getCombinedModel(psiElement);
        if (strutsModel == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/NamespaceReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new NamespaceReference((XmlAttributeValue)psiElement, strutsModel)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/NamespaceReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class NamespaceReference
    extends PsiReferenceBase.Poly<XmlAttributeValue>
    implements EmptyResolveMessageProvider {
        private static final Function<StrutsPackage, LookupElement> STRUTS_PACKAGE_LOOKUP_ELEMENT_FUNCTION = strutsPackage -> LookupElementBuilder.create((Object)strutsPackage.getXmlTag(), (String)strutsPackage.searchNamespace()).withTypeText(strutsPackage.getName().getStringValue());
        private final StrutsModel strutsModel;

        private NamespaceReference(XmlAttributeValue psiElement, StrutsModel strutsModel) {
            super((PsiElement)psiElement);
            this.strutsModel = strutsModel;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            String namespace = ((XmlAttributeValue)this.myElement).getValue();
            SmartList resolveResults = new SmartList();
            for (StrutsPackage strutsPackage : this.strutsModel.getStrutsPackages()) {
                if (!Comparing.equal((String)namespace, (String)strutsPackage.searchNamespace())) continue;
                XmlTag packageTag = strutsPackage.getXmlTag();
                assert (packageTag != null);
                resolveResults.add(new PsiElementResolveResult((PsiElement)packageTag));
            }
            ResolveResult[] resolveResultArray = (ResolveResult[])ArrayUtil.toObjectArray((Collection)resolveResults, ResolveResult.class);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/NamespaceReferenceProvider$NamespaceReference", "multiResolve"));
            }
            return resolveResultArray;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ContainerUtil.map2Array(this.strutsModel.getStrutsPackages(), LookupElement.class, STRUTS_PACKAGE_LOOKUP_ELEMENT_FUNCTION);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/NamespaceReferenceProvider$NamespaceReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "Cannot resolve namespace '" + this.getCanonicalText() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/NamespaceReferenceProvider$NamespaceReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }
}

