/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import java.io.IOException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.perforce.P4Revision;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceFileRevision
implements VcsFileRevision {
    private final P4Revision myP4Revision;
    private final PerforceVcsRevisionNumber myNumber;
    private final Project myProject;
    private final P4Connection myConnection;

    public PerforceFileRevision(@NotNull P4Revision p4Revision, @NotNull P4Connection connection, @NotNull Project project) {
        if (p4Revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p4Revision", "org/jetbrains/idea/perforce/application/PerforceFileRevision", "<init>"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/PerforceFileRevision", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/perforce/application/PerforceFileRevision", "<init>"));
        }
        this.myP4Revision = p4Revision;
        this.myProject = project;
        this.myNumber = new PerforceVcsRevisionNumber(this.myP4Revision);
        this.myConnection = connection;
    }

    public VcsRevisionNumber getRevisionNumber() {
        return this.myNumber;
    }

    public Date getRevisionDate() {
        return this.myP4Revision.getDate();
    }

    public String getAuthor() {
        return this.myP4Revision.getUser();
    }

    public String getCommitMessage() {
        return this.myP4Revision.getSubmitMessage();
    }

    public byte[] loadContent() throws IOException, VcsException {
        return PerforceRunner.getInstance(this.myProject).getByteContent(this.myP4Revision.getDepotPath(), "#" + this.myP4Revision.getRevisionNumber(), this.myConnection);
    }

    public byte[] getContent() throws IOException, VcsException {
        return ContentRevisionCache.getOrLoadAsBytes((Project)this.myProject, (FilePath)VcsContextFactory.SERVICE.getInstance().createFilePathOnNonLocal(this.myP4Revision.getDepotPath(), false), (VcsRevisionNumber)this.myNumber, (VcsKey)PerforceVcs.getKey(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REMOTE_CONTENT, () -> this.loadContent());
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public long getVersionNumber() {
        return this.myP4Revision.getRevisionNumber();
    }

    public String getAction() {
        return this.myP4Revision.getAction();
    }

    public String getClient() {
        return this.myP4Revision.getClient();
    }

    public String getBranchName() {
        return null;
    }

    @NotNull
    public P4Connection getConnection() {
        P4Connection p4Connection = this.myConnection;
        if (p4Connection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceFileRevision", "getConnection"));
        }
        return p4Connection;
    }
}

