/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;

public class PathsHelper {
    private final PerforceManager myPerforceManager;
    private final Collection<FilePath> myRecursivePaths = ContainerUtil.newArrayList();
    private final Collection<FilePath> mySimplePaths = ContainerUtil.newArrayList();

    public PathsHelper(PerforceManager perforceManager) {
        this.myPerforceManager = perforceManager;
    }

    public void add(FilePath path) {
        this.mySimplePaths.add(path);
    }

    public void addRecursively(FilePath path) {
        this.myRecursivePaths.add(path);
    }

    public void addAllPaths(Collection<FilePath> files) {
        this.mySimplePaths.addAll(files);
    }

    public boolean isEmpty() {
        return this.myRecursivePaths.isEmpty() && this.mySimplePaths.isEmpty();
    }

    public List<String> getRequestString() {
        ArrayList result = ContainerUtil.newArrayList();
        for (FilePath file : this.myRecursivePaths) {
            result.add(this.convert(PerforceRunner.getP4FilePath(P4File.create(file), file.isDirectory(), true)));
        }
        for (FilePath file : this.mySimplePaths) {
            result.add(this.convert(PerforceRunner.getP4FilePath(P4File.create(file), file.isDirectory(), false)));
        }
        return result;
    }

    private String convert(String s) {
        return this.myPerforceManager.convertP4ParsedPath(null, s);
    }
}

