/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlDeprecatedBuiltInsInspection
extends FtlSuppressableInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element.getParent() instanceof FtlBuiltIn && element.getNode().getElementType() == FtlElementTypes.IDENTIFIER) {
                    FtlBuiltIn builtIn = (FtlBuiltIn)element.getParent();
                    FtlBuiltInDescriptor descriptor = builtIn.getBuiltInDescriptor();
                    if (descriptor == null || !descriptor.isDeprecated()) {
                        return;
                    }
                    final String replacement = descriptor.getQuickFixReplacement(builtIn);
                    String message = FreeMarkerBundle.message("deprecated.builtin.usage", builtIn.getBuiltInName());
                    if (replacement == null) {
                        holder.registerProblem(element, message, new LocalQuickFix[0]);
                    } else {
                        holder.registerProblem(element, message, new LocalQuickFix[]{new LocalQuickFix(){

                            @NotNull
                            public String getName() {
                                String string = FreeMarkerBundle.message("replace.with.0", replacement);
                                if (string == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection$1$1", "getName"));
                                }
                                return string;
                            }

                            @NotNull
                            public String getFamilyName() {
                                String string = this.getName();
                                if (string == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection$1$1", "getFamilyName"));
                                }
                                return string;
                            }

                            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                if (project == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection$1$1", "applyFix"));
                                }
                                if (descriptor == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection$1$1", "applyFix"));
                                }
                                PsiElement psiElement = descriptor.getPsiElement();
                                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiElement.getContainingFile());
                                FtlBuiltIn builtIn = (FtlBuiltIn)psiElement.getParent();
                                PsiElement parent = builtIn.getParent();
                                int endOffset = (parent instanceof FtlMethodCallExpression ? parent : psiElement).getTextRange().getEndOffset();
                                document.replaceString(builtIn.getQuestionToken().getTextRange().getStartOffset(), endOffset, (CharSequence)replacement);
                            }
                        }});
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FreeMarkerBundle.message("ftl.deprecated.builtins.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("FtlDeprecatedBuiltInsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection", "getShortName"));
        }
        return "FtlDeprecatedBuiltInsInspection";
    }
}

