/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.freemarker.inspections.FtlReferencesInspection;
import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlAssignmentResolver;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlResolveResult;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.directives.FtlIfDirective;
import com.intellij.freemarker.psi.directives.FtlImportDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariable;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCallableVariable;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlMacroLoopVariable;
import com.intellij.freemarker.psi.variables.FtlNamespaceType;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.resolve.JavaMethodCandidateInfo;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FtlVariantsProcessor<T>
extends BaseScopeProcessor {
    @NonNls
    private static final THashSet<String> INSECURE_OBJECT_METHODS = new THashSet(Arrays.asList("wait", "notify", "notifyAll"));
    private final Set<T> myResult;
    private final Set<String> myMacroNames;
    private final boolean myForCompletion;
    private final PsiElement myParent;
    @Nullable
    private final String myReferenceName;
    private final boolean myMethodCall;
    private final JavaMethodResolveHelper myPropertyMethods;
    private final JavaMethodResolveHelper myMethods;
    private final FtlAssignmentResolver myAssignments;
    private final FtlAssignmentResolver myImplicits;
    private final FtlQualifiedReference myReference;
    private final PsiType[] myArgTypes;

    protected FtlVariantsProcessor(@NotNull FtlQualifiedReference reference, @Nullable String referenceName) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/freemarker/psi/FtlVariantsProcessor", "<init>"));
        }
        this.myResult = new LinkedHashSet<T>();
        this.myMacroNames = new THashSet();
        this.myAssignments = new FtlAssignmentResolver();
        this.myImplicits = new FtlAssignmentResolver();
        this.myReference = reference;
        this.myForCompletion = referenceName == null;
        this.myParent = reference.getExpressionParent();
        this.myReferenceName = referenceName;
        this.myMethodCall = this.myParent instanceof FtlMethodCallExpression;
        this.myArgTypes = this.myMethodCall && !this.myForCompletion ? ((FtlMethodCallExpression)this.myParent).getArgumentTypes() : null;
        this.myPropertyMethods = new FtlJavaMethodResolveHelper(this.myArgTypes);
        this.myMethods = new FtlJavaMethodResolveHelper(this.myArgTypes);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        boolean staticError;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/FtlVariantsProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/FtlVariantsProcessor", "execute"));
        }
        if (!(element instanceof PsiNamedElement)) {
            return true;
        }
        if (element instanceof PsiClass) {
            return true;
        }
        PsiNamedElement namedElement = (PsiNamedElement)element;
        if (StringUtil.isEmpty((String)namedElement.getName())) {
            return true;
        }
        boolean bl = staticError = state.get(FtlPsiType.STATIC_ERROR) == Boolean.TRUE;
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor()) {
                return true;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && INSECURE_OBJECT_METHODS.contains((Object)method.getName())) {
                return true;
            }
            if (!this.myMethodCall && (this.myReferenceName == null || this.myReferenceName.equals(PropertyUtil.getPropertyName((PsiMethod)method))) && PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) {
                if (!method.hasModifierProperty("public")) {
                    return true;
                }
                this.myPropertyMethods.addMethod(method, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), staticError);
            }
        }
        if (this.myReferenceName != null && !this.myReferenceName.equals(namedElement.getName())) {
            return true;
        }
        if (namedElement instanceof PsiModifierListOwner && !((PsiModifierListOwner)namedElement).hasModifierProperty("public")) {
            return true;
        }
        if (element instanceof PsiField) {
            if (!this.shouldExposeFields() && !(element instanceof PsiEnumConstant)) {
                return true;
            }
            PsiField field = (PsiField)element;
            String getterName = PropertyUtil.suggestGetterName((PsiField)field);
            for (PsiMethod method : field.getContainingClass().findMethodsByName(getterName, true)) {
                if (!PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) continue;
                return true;
            }
        }
        boolean isCallableVariable = false;
        boolean isMacroDirective = false;
        if (element instanceof FtlCallableVariable || element instanceof FtlImplicitVariable) {
            FtlType ftlType = ((FtlVariable)element).getType();
            FtlCallableType callableType = FtlPsiUtil.asInstanceOf(ftlType, FtlCallableType.class);
            isCallableVariable = callableType != null;
            boolean bl2 = isMacroDirective = isCallableVariable && callableType.isMacro();
        }
        if (!this.myForCompletion) {
            boolean isCallTarget;
            boolean bl3 = isCallableVariable ? !isMacroDirective : (isCallTarget = element instanceof PsiMethod);
            if (isCallTarget != this.myMethodCall) {
                return true;
            }
        } else {
            if (this.myParent instanceof FtlInterpolation && isMacroDirective) {
                return true;
            }
            if (this.myParent instanceof FtlMacro && !isMacroDirective && !FtlVariantsProcessor.isNamespace(element)) {
                return true;
            }
        }
        if (!(this.myParent instanceof FtlMacro) && PsiTreeUtil.getParentOfType((PsiElement)this.myParent, FtlArgumentList.class, (boolean)false) == null && isMacroDirective && !this.myForCompletion) {
            return true;
        }
        if (this.myReference.isMacroParameter(this.myForCompletion) && !(element instanceof FtlParameter)) {
            return true;
        }
        if (element instanceof PsiMethod) {
            this.myMethods.addMethod((PsiMethod)namedElement, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), staticError);
        } else if (element instanceof FtlAssignmentDeclaration) {
            this.myAssignments.addAssignment((FtlVariable)element, state.get(FtlIfDirective.MAYBE_UNDEFINED) == Boolean.TRUE, ((FtlAssignmentDeclaration)element).getDirective().getType());
        } else if (element instanceof FtlLoopVariable || element instanceof FtlMacroLoopVariable || element instanceof FtlParameterDeclaration) {
            this.myAssignments.addAssignment((FtlVariable)element, false, FtlAssignmentType.LOCAL);
        } else if (element instanceof FtlImplicitVariable) {
            FtlImplicitVariable variable = (FtlImplicitVariable)element;
            FtlAssignmentType assignmentType = element.getContainingFile() == this.myParent.getContainingFile() || !variable.isGlobal() ? FtlAssignmentType.ASSIGN : FtlAssignmentType.GLOBAL;
            this.myImplicits.addAssignment(variable, false, assignmentType);
        } else {
            if (element instanceof FtlSignatureDirective && !this.myMacroNames.add(((FtlSignatureDirective)element).getName())) {
                return true;
            }
            ContainerUtil.addIfNotNull(this.myResult, this.execute(namedElement, staticError ? JavaMethodResolveHelper.ErrorType.STATIC : JavaMethodResolveHelper.ErrorType.NONE, (PsiSubstitutor)state.get(PsiSubstitutor.KEY)));
        }
        return true;
    }

    private boolean shouldExposeFields() {
        FtlFile file = this.myReference.getElement().getContainingFile();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)file.getProject()).getCurrentProfile();
        InspectionToolWrapper wrapper = profile.getInspectionTool("FtlReferencesInspection", (PsiElement)file);
        if (wrapper == null) {
            return false;
        }
        return ((FtlReferencesInspection)wrapper.getTool()).fieldsExposed;
    }

    private static boolean isNamespace(PsiElement element) {
        return element instanceof FtlImportDirective || element instanceof FtlVariable && FtlPsiUtil.asInstanceOf(((FtlVariable)element).getType(), FtlNamespaceType.class) != null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/freemarker/psi/FtlVariantsProcessor", "handleEvent"));
        }
        this.myMethods.handleEvent(event, associated);
        this.myPropertyMethods.handleEvent(event, associated);
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL) {
            this.myAssignments.handleLevelChange();
        }
        super.handleEvent(event, associated);
    }

    @Nullable
    protected abstract T execute(PsiNamedElement var1, JavaMethodResolveHelper.ErrorType var2, PsiSubstitutor var3);

    @NotNull
    public T[] toArray(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/freemarker/psi/FtlVariantsProcessor", "toArray"));
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.myResult);
        boolean hasParameters = false;
        for (FtlResolveResult declaration : this.myAssignments.getResults()) {
            PsiNamedElement element = (PsiNamedElement)declaration.getElement();
            T variant = this.execute(element, declaration.getResolveError(), PsiSubstitutor.EMPTY);
            if (variant == null) continue;
            if (element instanceof FtlParameterDeclaration) {
                hasParameters = true;
            }
            result.add(variant);
        }
        if (!hasParameters) {
            for (JavaMethodCandidateInfo ci : this.myPropertyMethods.getMethods()) {
                PsiMethod method = ci.getMethod();
                String propertyName = PropertyUtil.getPropertyName((PsiMethod)method);
                BeanPropertyElement element = new BeanPropertyElement(method, propertyName);
                ContainerUtil.addIfNotNull(result, this.execute((PsiNamedElement)element, this.myPropertyMethods.getResolveError(), ci.getSubstitutor()));
            }
            for (JavaMethodCandidateInfo ci : this.myMethods.getMethods()) {
                ContainerUtil.addIfNotNull(result, this.execute((PsiNamedElement)ci.getMethod(), this.myMethods.getResolveError(), ci.getSubstitutor()));
            }
            for (FtlResolveResult declaration : this.myImplicits.getResults()) {
                ContainerUtil.addIfNotNull(result, this.execute((PsiNamedElement)declaration.getElement(), declaration.getResolveError(), PsiSubstitutor.EMPTY));
            }
        }
        T[] TArray = result.toArray(array);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlVariantsProcessor", "toArray"));
        }
        return TArray;
    }

    @Nullable
    public String getReferenceName() {
        return this.myReferenceName;
    }

    public boolean isMethodCall() {
        return this.myMethodCall;
    }

    private static class MethodCandidateInfoWithConversion
    extends MethodCandidateInfo {
        public MethodCandidateInfoWithConversion(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean accessProblem, boolean staticProblem, PsiElement argumentList, PsiElement currentFileContext, PsiType[] newArgTypes, @NotNull LanguageLevel languageLevel) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/freemarker/psi/FtlVariantsProcessor$MethodCandidateInfoWithConversion", "<init>"));
            }
            if (languageLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/freemarker/psi/FtlVariantsProcessor$MethodCandidateInfoWithConversion", "<init>"));
            }
            super((PsiElement)method, substitutor, accessProblem, staticProblem, argumentList, currentFileContext, newArgTypes, PsiType.EMPTY_ARRAY, languageLevel);
        }
    }

    private class FtlJavaMethodResolveHelper
    extends JavaMethodResolveHelper {
        public FtlJavaMethodResolveHelper(PsiType[] args) {
            super(FtlVariantsProcessor.this.myParent, FtlVariantsProcessor.this.myParent.getContainingFile(), args);
        }

        protected List<CandidateInfo> getCandidates() {
            List candidates = super.getCandidates();
            ArrayList normal = ContainerUtil.newArrayList();
            ArrayList converted = ContainerUtil.newArrayList();
            for (CandidateInfo candidate : candidates) {
                (candidate instanceof MethodCandidateInfoWithConversion ? converted : normal).add(candidate);
            }
            return normal.isEmpty() ? converted : normal;
        }

        protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean staticProblem, PsiElement currentFileContext, boolean accessProblem, PsiElement argumentList, PsiType[] argumentTypes, @NotNull LanguageLevel languageLevel, final boolean vararg) {
            PsiType[] newArgTypes;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/freemarker/psi/FtlVariantsProcessor$FtlJavaMethodResolveHelper", "createCandidateInfo"));
            }
            if (languageLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/freemarker/psi/FtlVariantsProcessor$FtlJavaMethodResolveHelper", "createCandidateInfo"));
            }
            PsiParameterList list = method.getParameterList();
            if (FtlVariantsProcessor.this.myArgTypes != null && list.getParametersCount() == FtlVariantsProcessor.this.myArgTypes.length && (newArgTypes = this.replaceStringWithChar(list)) != null) {
                return new MethodCandidateInfoWithConversion(method, substitutor, accessProblem, staticProblem, argumentList, currentFileContext, newArgTypes, languageLevel){

                    public boolean isVarargs() {
                        return vararg;
                    }
                };
            }
            return super.createCandidateInfo(method, substitutor, staticProblem, currentFileContext, accessProblem, argumentList, argumentTypes, languageLevel, vararg);
        }

        private PsiType[] replaceStringWithChar(PsiParameterList list) {
            PsiType[] newArgTypes = null;
            PsiParameter[] parameters = list.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (!PsiType.CHAR.equals((Object)parameters[i].getType()) || !FtlVariantsProcessor.this.myArgTypes[i].equalsToText("java.lang.String")) continue;
                if (newArgTypes == null) {
                    newArgTypes = (PsiType[])FtlVariantsProcessor.this.myArgTypes.clone();
                }
                newArgTypes[i] = PsiType.CHAR;
            }
            return newArgTypes;
        }
    }
}

