/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.gwt.i18n.GwtI18nUtil;
import com.intellij.gwt.i18n.PropertiesFilesListCellRenderer;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.ide.DataManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtInconsistentLocalizableInterfaceInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtInconsistentLocalizableInterfaceInspection");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.inconsistent.gwt.localizable.interface", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GwtInconsistentI18nInterface" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection", "getShortName"));
        }
        return "GwtInconsistentI18nInterface";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection", "checkFile"));
        }
        GwtFacet gwtFacet = GwtInconsistentLocalizableInterfaceInspection.getFacet((PsiElement)file);
        if (gwtFacet == null) {
            return null;
        }
        if (file instanceof PropertiesFile) {
            PropertiesFile propertiesFile = (PropertiesFile)file;
            return GwtInconsistentLocalizableInterfaceInspection.checkPropertiesFile(manager, propertiesFile, gwtFacet, isOnTheFly);
        }
        if (file instanceof PsiJavaFile) {
            PsiClass[] psiClasses;
            for (PsiClass psiClass : psiClasses = ((PsiJavaFile)file).getClasses()) {
                ProblemDescriptor[] descriptors = GwtInconsistentLocalizableInterfaceInspection.checkPsiClass(manager, psiClass, isOnTheFly);
                if (descriptors == null) continue;
                return descriptors;
            }
        }
        return null;
    }

    @Nullable
    private static ProblemDescriptor[] checkPsiClass(InspectionManager manager, PsiClass psiClass, boolean onTheFly) {
        GwtI18nManager i18nManager = GwtI18nManager.getInstance(manager.getProject());
        PropertiesFile[] files = i18nManager.getPropertiesFiles(psiClass);
        if (files.length == 0) {
            return null;
        }
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            IProperty[] properties;
            if (GwtInconsistentLocalizableInterfaceInspection.hasDefaultValue(psiMethod) || (properties = i18nManager.getProperties(psiMethod)).length != 0) continue;
            String description = GwtBundle.message("problem.description.method.0.does.not.have.corresponding.property", psiMethod.getName());
            DefinePropertyQuickfix quickFix = new DefinePropertyQuickfix(GwtI18nUtil.getPropertyName(psiMethod), files);
            descriptors.add(manager.createProblemDescriptor(GwtInconsistentLocalizableInterfaceInspection.getElementToHighlight(psiMethod), description, (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    private static boolean hasDefaultValue(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection", "hasDefaultValue"));
        }
        for (PsiAnnotation annotation : psiMethod.getModifierList().getAnnotations()) {
            String name = annotation.getQualifiedName();
            if (name == null || !name.startsWith("com.google.gwt.i18n.client.Constants.Default") && !name.equals("com.google.gwt.i18n.client.Messages.DefaultMessage")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static ProblemDescriptor[] checkPropertiesFile(InspectionManager manager, PropertiesFile propertiesFile, GwtFacet gwtFacet, boolean onTheFly) {
        GwtI18nManager i18nManager = GwtI18nManager.getInstance(manager.getProject());
        PsiClass anInterface = i18nManager.getPropertiesInterface(propertiesFile);
        if (anInterface == null) {
            return null;
        }
        ArrayList<IProperty> propertiesWithoutMethods = new ArrayList<IProperty>();
        List properties = propertiesFile.getProperties();
        for (IProperty property : properties) {
            PsiMethod method = i18nManager.getMethod(property);
            if (method != null || property.getUnescapedKey() == null) continue;
            propertiesWithoutMethods.add(property);
        }
        if (propertiesWithoutMethods.isEmpty()) {
            return null;
        }
        SynchronizeInterfaceQuickFix syncAllQuickfix = propertiesWithoutMethods.size() > 1 ? new SynchronizeInterfaceQuickFix(anInterface, propertiesWithoutMethods, gwtFacet.getSdkVersion()) : null;
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (IProperty property : propertiesWithoutMethods) {
            LocalQuickFix[] localQuickFixArray;
            String key = property.getUnescapedKey();
            AddMethodToInterfaceQuickFix quickFix = new AddMethodToInterfaceQuickFix(anInterface, key, property.getValue(), gwtFacet.getSdkVersion());
            if (syncAllQuickfix == null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = quickFix;
            } else {
                LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[2];
                localQuickFixArray3[0] = syncAllQuickfix;
                localQuickFixArray = localQuickFixArray3;
                localQuickFixArray3[1] = quickFix;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            String description = GwtBundle.message("problem.description.property.0.does.not.have.corresponding.method.in.1", key, anInterface.getName());
            problems.add(manager.createProblemDescriptor(property.getPsiElement(), description, onTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static void defineProperty(final PropertiesFile propertiesFile, final String propertyName) {
        IProperty property = (IProperty)new WriteCommandAction<IProperty>(propertiesFile.getProject(), new PsiFile[]{propertiesFile.getContainingFile()}){

            protected void run(@NotNull Result<IProperty> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$1", "run"));
                }
                result.setResult((Object)GwtInconsistentLocalizableInterfaceInspection.definePropertyImpl(propertiesFile, propertyName));
            }
        }.execute().getResultObject();
        if (property != null) {
            GwtI18nUtil.navigateToProperty(property);
        }
    }

    @Nullable
    private static IProperty definePropertyImpl(PropertiesFile propertiesFile, String propertyName) {
        try {
            return propertiesFile.addProperty(propertyName, "");
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static boolean ensureWritable(PsiElement element) {
        return !ReadonlyStatusHandler.getInstance((Project)element.getProject()).ensureFilesWritable(new VirtualFile[]{element.getContainingFile().getVirtualFile()}).hasReadonlyFiles();
    }

    private static class DefinePropertyQuickfix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.property", new Object[0]);
        private final String myPropertyName;
        private final PropertiesFile[] myPropertiesFiles;

        public DefinePropertyQuickfix(String propertyName, PropertiesFile[] propertiesFiles) {
            super(GwtBundle.message("quickfix.name.create.property.0", propertyName));
            this.myPropertyName = propertyName;
            this.myPropertiesFiles = propertiesFiles;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$DefinePropertyQuickfix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$DefinePropertyQuickfix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$DefinePropertyQuickfix", "applyFix"));
            }
            if (this.myPropertiesFiles.length == 1) {
                IProperty property;
                PropertiesFile file = this.myPropertiesFiles[0];
                if (GwtInconsistentLocalizableInterfaceInspection.ensureWritable((PsiElement)file.getContainingFile()) && (property = GwtInconsistentLocalizableInterfaceInspection.definePropertyImpl(file, this.myPropertyName)) != null) {
                    GwtI18nUtil.navigateToProperty(property);
                }
                return;
            }
            JBList list = new JBList((Object[])this.myPropertiesFiles);
            PropertiesFilesListCellRenderer renderer = new PropertiesFilesListCellRenderer();
            list.setCellRenderer(renderer);
            list.setSelectionMode(0);
            PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
            renderer.installSpeedSearch(builder);
            builder.setTitle(GwtBundle.message("quickfix.popup.title.choose.properties.file", new Object[0])).setItemChoosenCallback(() -> this.lambda$applyFix$0((JList)list)).createPopup().showInBestPositionFor(DataManager.getInstance().getDataContext());
        }

        private /* synthetic */ void lambda$applyFix$0(JList list) {
            int index = list.getSelectedIndex();
            if (index != -1) {
                GwtInconsistentLocalizableInterfaceInspection.defineProperty(this.myPropertiesFiles[index], this.myPropertyName);
            }
        }
    }

    private static class SynchronizeInterfaceQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.missing.methods", new Object[0]);
        private final PsiClass myInterface;
        private final GwtVersion myGwtVersion;
        private final List<IProperty> myProperties;

        public SynchronizeInterfaceQuickFix(PsiClass anInterface, List<IProperty> properties, GwtVersion gwtVersion) {
            super(GwtBundle.message("quickfix.name.synchronize.all.methods.in.0", anInterface.getName()));
            this.myProperties = properties;
            this.myInterface = anInterface;
            this.myGwtVersion = gwtVersion;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$SynchronizeInterfaceQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$SynchronizeInterfaceQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$SynchronizeInterfaceQuickFix", "applyFix"));
            }
            if (!GwtInconsistentLocalizableInterfaceInspection.ensureWritable((PsiElement)this.myInterface)) {
                return;
            }
            for (IProperty property : this.myProperties) {
                GwtI18nUtil.addMethod(this.myInterface, property.getUnescapedKey(), property.getValue(), this.myGwtVersion);
            }
        }
    }

    private static class AddMethodToInterfaceQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.missing.methods", new Object[0]);
        private final PsiClass myInterface;
        private final String myPropertyName;
        private final String myPropertyValue;
        private final GwtVersion myGwtVersion;

        public AddMethodToInterfaceQuickFix(PsiClass anInterface, String propertyName, String value, GwtVersion gwtVersion) {
            super(GwtBundle.message("quickfix.name.create.method.for.property.0.in.1", propertyName, anInterface.getName()));
            this.myInterface = anInterface;
            this.myPropertyName = propertyName;
            this.myPropertyValue = value;
            this.myGwtVersion = gwtVersion;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$AddMethodToInterfaceQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$AddMethodToInterfaceQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$AddMethodToInterfaceQuickFix", "applyFix"));
            }
            if (!GwtInconsistentLocalizableInterfaceInspection.ensureWritable((PsiElement)this.myInterface)) {
                return;
            }
            GwtI18nUtil.addMethod(this.myInterface, this.myPropertyName, this.myPropertyValue, this.myGwtVersion);
        }
    }
}

