/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.psi;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.make.GwtCompilerPaths;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtFileSet;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.module.model.GwtRelativePath;
import com.intellij.gwt.module.model.impl.GwtFilePatternUtil;
import com.intellij.gwt.psi.GwtLanguageLevelPusher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.webcore.ModuleHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.impl.GwtSourcePath;
import org.jetbrains.jps.gwt.model.impl.GwtSourcePathsSet;

public class GwtSourcePathsRefresherProjectComponent
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance(GwtSourcePathsRefresherProjectComponent.class);
    private final GwtSourcePathsSet mySourcePathsSet = new GwtSourcePathsSet();
    private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("name", 1000, true, MergingUpdateQueue.ANY_COMPONENT);

    public static GwtSourcePathsRefresherProjectComponent getInstance(Project project) {
        return (GwtSourcePathsRefresherProjectComponent)((Object)project.getComponent(GwtSourcePathsRefresherProjectComponent.class));
    }

    public GwtSourcePathsRefresherProjectComponent(Project project) {
        super(project);
        File gwtSourcePathsFile;
        if (!ApplicationManager.getApplication().isUnitTestMode() && (gwtSourcePathsFile = GwtCompilerPaths.getGwtSourcePaths(this.myProject)).exists()) {
            try {
                Element element = JDOMUtil.load((File)gwtSourcePathsFile);
                PathMacroManager.getInstance((ComponentManager)this.myProject).expandPaths(element);
                XmlSerializer.deserializeInto((Object)this.mySourcePathsSet, (Element)element);
            }
            catch (IOException | JDOMException e) {
                LOG.error("Unable to load file " + gwtSourcePathsFile.getAbsolutePath(), e);
            }
        }
    }

    public void disposeComponent() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            File gwtSourcePathsFile = GwtCompilerPaths.getGwtSourcePaths(this.myProject);
            Element element = XmlSerializer.serialize((Object)this.mySourcePathsSet);
            try {
                if (!gwtSourcePathsFile.exists()) {
                    if (this.mySourcePathsSet.mySourcePaths.isEmpty()) {
                        return;
                    }
                    FileUtil.createParentDirs((File)gwtSourcePathsFile);
                    gwtSourcePathsFile.createNewFile();
                }
                PathMacroManager.getInstance((ComponentManager)this.myProject).collapsePathsRecursively(element);
                JDOMUtil.writeParent((Parent)element, (File)gwtSourcePathsFile, (String)"\n");
            }
            catch (IOException e) {
                LOG.error("Unable to save file " + gwtSourcePathsFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    @NotNull
    public String getComponentName() {
        if ("GwtSourcePathsRefresher" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent", "getComponentName"));
        }
        return "GwtSourcePathsRefresher";
    }

    public void initComponent() {
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent$1", "after"));
                }
                GwtSourcePathsRefresherProjectComponent.this.processAfterVfsChanges(events);
            }
        });
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeListener());
    }

    public void enqueueRefreshSourcePathsTask(boolean forcePush) {
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        dumbService.runWhenSmart(() -> {
            Set<GwtSourcePath> sourcePaths = this.getPaths(GwtModule::getSourceRoots);
            Set<GwtSourcePath> superSourcePaths = this.getPaths(GwtModule::getSuperSourceRoots);
            boolean push = false;
            if (!sourcePaths.equals(this.mySourcePathsSet.mySourcePaths)) {
                push = true;
                this.mySourcePathsSet.mySourcePaths.clear();
                this.mySourcePathsSet.mySourcePaths.addAll(sourcePaths);
                this.sourcePathsChanged();
            }
            if (!superSourcePaths.equals(this.mySourcePathsSet.mySuperSourcePaths)) {
                push = true;
                this.mySourcePathsSet.mySuperSourcePaths.clear();
                this.mySourcePathsSet.mySuperSourcePaths.addAll(superSourcePaths);
                this.superSourcePathsChanged();
            }
            if (push || forcePush) {
                this.enqueuePushTask(dumbService);
            }
        });
    }

    private void sourcePathsChanged() {
    }

    private void superSourcePathsChanged() {
        for (Module module : ModuleHelper.getModules((Project)this.myProject)) {
            GwtFacet gwtFacet = GwtFacet.getInstance(module);
            if (gwtFacet == null) continue;
            ((GwtFacetConfiguration)gwtFacet.getConfiguration()).getSdk().invalidateSuperSourceCache();
        }
    }

    @NotNull
    private Set<GwtSourcePath> getPaths(Function<GwtModule, Map<VirtualFile, GwtRelativePath>> getPaths) {
        GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(this.myProject);
        HashSet sourcePaths = ContainerUtil.newHashSet();
        for (Module module : ModuleHelper.getModules((Project)this.myProject)) {
            GwtFacet gwtFacet = GwtFacet.getInstance(module);
            if (gwtFacet == null) continue;
            List<GwtModule> gwtModules = gwtModulesManager.getGwtModules(module, true);
            for (GwtModule gwtModule : gwtModules) {
                Map<VirtualFile, GwtRelativePath> sourceRoots = getPaths.apply(gwtModule);
                for (Map.Entry<VirtualFile, GwtRelativePath> entry : sourceRoots.entrySet()) {
                    GwtRelativePath relativePath = entry.getValue();
                    if (relativePath == null) continue;
                    sourcePaths.add(new GwtSourcePath(entry.getKey().getPath(), GwtSourcePathsRefresherProjectComponent.getBoolean((Boolean)relativePath.isCaseSensitive().getValue()), GwtSourcePathsRefresherProjectComponent.getBoolean((Boolean)relativePath.isDefaultExcludes().getValue()), GwtSourcePathsRefresherProjectComponent.mergePatterns((String)relativePath.getIncludesAttribute().getValue(), relativePath.getIncludes()), GwtSourcePathsRefresherProjectComponent.mergePatterns((String)relativePath.getExcludesAttribute().getValue(), relativePath.getExcludes())));
                }
            }
        }
        HashSet hashSet = sourcePaths;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent", "getPaths"));
        }
        return hashSet;
    }

    private void enqueuePushTask(final DumbService dumbService) {
        this.myUpdateQueue.queue(new Update((Object)this){

            public void run() {
                if (GwtSourcePathsRefresherProjectComponent.this.myUpdateQueue.isPassThrough()) {
                    GwtLanguageLevelPusher.pushGwtLanguageLevel(GwtSourcePathsRefresherProjectComponent.this.myProject);
                } else {
                    dumbService.queueTask(new DumbModeTask((Object)GwtSourcePathsRefresherProjectComponent.this){

                        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent$2$1", "performInDumbMode"));
                            }
                            GwtLanguageLevelPusher.pushGwtLanguageLevel(GwtSourcePathsRefresherProjectComponent.this.myProject);
                        }
                    });
                }
            }
        });
    }

    public boolean isSourceFile(VirtualFile file) {
        return this.isInPaths(file, this.mySourcePathsSet.mySourcePaths);
    }

    public boolean isSuperSourceFile(VirtualFile file) {
        return this.isInPaths(file, this.mySourcePathsSet.mySuperSourcePaths);
    }

    public Set<GwtSourcePath> getSuperSourcePaths(List<GwtModule> gwtModules) {
        if (gwtModules.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList gwtModulePaths = ContainerUtil.newArrayListWithCapacity((int)gwtModules.size());
        for (GwtModule gwtModule : gwtModules) {
            gwtModulePaths.add(gwtModule.getModuleDirectory().getPath());
        }
        HashSet superSourcePaths = ContainerUtil.newHashSet();
        block1: for (GwtSourcePath gwtSourcePath : this.mySourcePathsSet.mySuperSourcePaths) {
            for (String modulePath : gwtModulePaths) {
                if (!FileUtil.isAncestor((String)modulePath, (String)gwtSourcePath.getFullPath(), (boolean)false)) continue;
                superSourcePaths.add(gwtSourcePath);
                continue block1;
            }
        }
        return superSourcePaths;
    }

    private boolean isInPaths(VirtualFile file, Set<GwtSourcePath> paths) {
        for (GwtSourcePath sourcePath : paths) {
            if (!FileUtil.isAncestor((String)sourcePath.getFullPath(), (String)file.getPath(), (boolean)false) || !this.isIncluded(file.getPath(), sourcePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isIncluded(String filePath, GwtSourcePath sourcePath) {
        String path = FileUtil.getRelativePath((String)sourcePath.getFullPath(), (String)filePath, (char)'/');
        if (path == null) {
            return false;
        }
        if (sourcePath.defaultExcludes() && GwtFilePatternUtil.isExcludedByDefault(path, sourcePath.caseSensitive())) {
            return false;
        }
        return !sourcePath.excludes(path) && sourcePath.includes(path);
    }

    private void processAfterVfsChanges(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent", "processAfterVfsChanges"));
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null) continue;
            if (file.isDirectory()) {
                if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCopyEvent) && !(vFileEvent instanceof VFileDeleteEvent)) continue;
                this.enqueueRefreshSourcePathsTask(false);
                return;
            }
            if (!file.getName().endsWith(".gwt.xml") || !(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileDeleteEvent) && !(vFileEvent instanceof VFileContentChangeEvent)) continue;
            this.enqueueRefreshSourcePathsTask(false);
            return;
        }
    }

    private static boolean getBoolean(@Nullable Boolean value) {
        return value == null || value != false;
    }

    @NotNull
    private static List<String> mergePatterns(@Nullable String patterns, @Nullable List<GwtFileSet> patternsList) {
        if (patterns == null && ContainerUtil.isEmpty(patternsList)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent", "mergePatterns"));
            }
            return list;
        }
        String[] patternsArray = patterns == null ? ArrayUtil.EMPTY_STRING_ARRAY : patterns.split("(\\s|,)");
        patternsList = ContainerUtil.notNullize(patternsList);
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)(patternsArray.length + patternsList.size()));
        Collections.addAll(result, patternsArray);
        for (GwtFileSet fileSet : patternsList) {
            result.add(fileSet.getName().getValue());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent", "mergePatterns"));
        }
        return arrayList;
    }

    private class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        private void processEvent(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent$MyPsiTreeChangeListener", "processEvent"));
            }
            PsiFile file = event.getFile();
            if (file == null || !file.getName().endsWith(".gwt.xml")) {
                return;
            }
            GwtSourcePathsRefresherProjectComponent.this.enqueueRefreshSourcePathsTask(false);
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent$MyPsiTreeChangeListener", "childAdded"));
            }
            this.processEvent(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent$MyPsiTreeChangeListener", "childRemoved"));
            }
            this.processEvent(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent$MyPsiTreeChangeListener", "childReplaced"));
            }
            this.processEvent(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent$MyPsiTreeChangeListener", "childrenChanged"));
            }
            this.processEvent(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/psi/GwtSourcePathsRefresherProjectComponent$MyPsiTreeChangeListener", "childMoved"));
            }
            this.processEvent(event);
        }
    }
}

