/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.sdk.impl;

import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.psi.GwtSourcePathsRefresherProjectComponent;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.superSource.GwtSuperSourceClassCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.GwtSourcePath;

public abstract class GwtSdkBase
implements GwtSdk {
    private final Map<String, Boolean> myCachedJreEmulationClasses = new HashMap<String, Boolean>();
    private final Map<String, Couple<String>> myCachedSuperSourceClasses = new HashMap<String, Couple<String>>();
    @Nullable
    protected GwtVersion myVersion;
    protected final GwtSdkPaths myPaths;

    protected GwtSdkBase(GwtSdkPaths paths) {
        this.myPaths = paths;
    }

    @Override
    public boolean containsJreEmulationClass(List<GwtModule> gwtModules, String className) {
        Boolean contains = this.myCachedJreEmulationClasses.get(className);
        if (contains == null) {
            VirtualFile userJar = this.getUserJar();
            contains = userJar != null && userJar.findFileByRelativePath(GwtSdkUtil.getJreEmulationClassPath(className)) != null;
            this.myCachedJreEmulationClasses.put(className, contains);
        }
        if (contains.booleanValue()) {
            return true;
        }
        if (gwtModules.isEmpty()) {
            return false;
        }
        Project project = gwtModules.get(0).getModule().getProject();
        GwtSuperSourceClassCache sourceClassCache = GwtSuperSourceClassCache.getInstance(project);
        Couple<String> cachedValue = this.myCachedSuperSourceClasses.get(className);
        if (cachedValue != null) {
            PsiFile psiFile;
            String virtualFilePath = (String)cachedValue.getFirst();
            String outerClassName = (String)cachedValue.getSecond();
            VirtualFile virtualFileWithRequiredClass = LocalFileSystem.getInstance().findFileByPath(virtualFilePath);
            if (virtualFileWithRequiredClass != null && (psiFile = sourceClassCache.getCachedPsiFile(virtualFileWithRequiredClass)) instanceof PsiJavaFile) {
                for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                    if (!outerClassName.equals(aClass.getQualifiedName())) continue;
                    if (className.equals(outerClassName)) {
                        return true;
                    }
                    String subclassName = StringUtil.trimStart((String)className, (String)outerClassName).substring(1);
                    PsiClass result = GwtSuperSourceClassCache.findInnerClass(aClass, StringUtil.split((String)subclassName, (String)"."));
                    if (result == null) break;
                    return true;
                }
            }
            this.myCachedSuperSourceClasses.remove(className);
        }
        GwtSourcePathsRefresherProjectComponent sourcePathsRefresher = (GwtSourcePathsRefresherProjectComponent)((Object)project.getComponent(GwtSourcePathsRefresherProjectComponent.class));
        for (GwtSourcePath superSourcePath : sourcePathsRefresher.getSuperSourcePaths(gwtModules)) {
            String filePath;
            PsiClass psiClass;
            VirtualFile superSourceRoot = LocalFileSystem.getInstance().findFileByPath(superSourcePath.myFullPath);
            if (superSourceRoot == null || (psiClass = (PsiClass)ContainerUtil.getFirstItem(sourceClassCache.findClassesByQualifiedName(className, superSourceRoot))) == null || !sourcePathsRefresher.isIncluded(filePath = psiClass.getContainingFile().getVirtualFile().getPath(), superSourcePath)) continue;
            String relativePath = FileUtil.getRelativePath((String)superSourcePath.getFullPath(), (String)filePath, (char)'/');
            String outerClassName = FileUtil.getNameWithoutExtension((String)relativePath).replace('/', '.');
            this.myCachedSuperSourceClasses.put(className, (Couple<String>)Couple.of((Object)filePath, (Object)outerClassName));
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PsiClass findJreEmulationClass(List<GwtModule> gwtModules, @NotNull PsiClass originalClass) {
        if (originalClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalClass", "com/intellij/gwt/sdk/impl/GwtSdkBase", "findJreEmulationClass"));
        }
        String className = originalClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        Project project = originalClass.getProject();
        GwtSuperSourceClassCache sourceClassCache = GwtSuperSourceClassCache.getInstance(project);
        GwtSourcePathsRefresherProjectComponent sourcePathsRefresher = (GwtSourcePathsRefresherProjectComponent)((Object)project.getComponent(GwtSourcePathsRefresherProjectComponent.class));
        for (GwtSourcePath sourcePath : sourcePathsRefresher.getSuperSourcePaths(gwtModules)) {
            PsiClass psiClass;
            VirtualFile superSourceRoot = LocalFileSystem.getInstance().findFileByPath(sourcePath.myFullPath);
            if (superSourceRoot == null || (psiClass = (PsiClass)ContainerUtil.getFirstItem(sourceClassCache.findClassesByQualifiedName(className, superSourceRoot))) == null || !sourcePathsRefresher.isIncluded(psiClass.getContainingFile().getVirtualFile().getPath(), sourcePath)) continue;
            return psiClass;
        }
        VirtualFile userJar = this.getUserJar();
        if (userJar == null) {
            return null;
        }
        VirtualFile root = userJar.findFileByRelativePath("com/google/gwt/emul/");
        if (root == null) {
            return null;
        }
        return (PsiClass)ContainerUtil.getFirstItem(sourceClassCache.findClassesByQualifiedName(className, root));
    }

    @Override
    public void invalidateSuperSourceCache() {
        this.myCachedSuperSourceClasses.clear();
    }

    @Override
    @NotNull
    public GwtVersion getVersion() {
        if (this.myVersion == null) {
            this.myVersion = this.detectVersion();
        }
        GwtVersion gwtVersion = this.myVersion;
        if (gwtVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtSdkBase", "getVersion"));
        }
        return gwtVersion;
    }

    @NotNull
    protected abstract GwtVersion detectVersion();

    @Override
    @Nullable
    public VirtualFile getUserJar() {
        return GwtSdkUtil.findJarFile(this.getUserJarPath());
    }

    @Override
    public String getHomeDirectoryUrl() {
        return this.myPaths.getHomeDirectoryUrl();
    }

    @Override
    public String getDevJarPath() {
        return this.myPaths.getDevJarPath(this.getVersion().isUseSystemIndependentGwtDevJar());
    }

    @Override
    public String getServletJarPath() {
        return this.myPaths.getServletJarPath();
    }

    @Override
    public String getUserJarPath() {
        return this.myPaths.getUserJarPath();
    }

    @Override
    public String getCodeServerJarPath() {
        return this.myPaths.getCodeServerJarPath();
    }

    @Override
    public List<String> getAdditionalCompilerJars() {
        return this.myPaths.getAdditionalCompilerJars();
    }
}

