/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.tooling.internal.consumer.ExecutorServiceFactory;
import org.gradle.util.DistributionLocator;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.Logger;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;

public class DistributionFactoryExt
extends DistributionFactory {
    private final ExecutorServiceFactory myExecutorFactory;

    public DistributionFactoryExt(ExecutorServiceFactory executorFactory) {
        super((Factory)executorFactory);
        this.myExecutorFactory = executorFactory;
    }

    public Distribution getWrappedDistribution(File propertiesFile) {
        WrapperExecutor wrapper = WrapperExecutor.forWrapperPropertiesFile((File)propertiesFile, (Appendable)System.out);
        if (wrapper.getDistribution() != null) {
            return new ZippedDistribution(wrapper.getConfiguration(), (Factory)this.myExecutorFactory);
        }
        return this.getDownloadedDistribution(GradleVersion.current().getVersion());
    }

    private Distribution getDownloadedDistribution(String gradleVersion) {
        URI distUri = new DistributionLocator().getDistributionFor(GradleVersion.version((String)gradleVersion));
        return this.getDistribution(distUri);
    }

    private static class ZippedDistribution
    implements Distribution {
        private InstalledDistribution installedDistribution;
        private final WrapperConfiguration wrapperConfiguration;
        private final Factory<? extends ExecutorService> executorFactory;

        private ZippedDistribution(WrapperConfiguration wrapperConfiguration, Factory<? extends ExecutorService> executorFactory) {
            this.wrapperConfiguration = wrapperConfiguration;
            this.executorFactory = executorFactory;
        }

        public String getDisplayName() {
            return String.format("Gradle distribution '%s'", this.wrapperConfiguration.getDistribution());
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, File userHomeDir, BuildCancellationToken cancellationToken) {
            if (this.installedDistribution == null) {
                File installDir;
                Callable<File> installDistroTask = () -> {
                    File installDir;
                    try {
                        File realUserHomeDir = userHomeDir != null ? userHomeDir : GradleUserHomeLookup.gradleUserHome();
                        Install install = new Install(new Logger(false), (IDownload)new ProgressReportingDownload(progressLoggerFactory), new PathAssembler(realUserHomeDir));
                        installDir = install.createDist(this.wrapperConfiguration);
                    }
                    catch (FileNotFoundException e) {
                        throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.getDisplayName()), e);
                    }
                    catch (CancellationException e) {
                        throw new BuildCancelledException(String.format("Distribution download cancelled. Using distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                    }
                    return installDir;
                };
                ExecutorService executor = null;
                try {
                    executor = (ExecutorService)this.executorFactory.create();
                    Future<File> installDirFuture = executor.submit(installDistroTask);
                    cancellationToken.addCallback(() -> installDirFuture.cancel(true));
                    installDir = installDirFuture.get();
                }
                catch (CancellationException e) {
                    throw new BuildCancelledException(String.format("Distribution download cancelled. Using distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() != null) {
                        UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
                    }
                    throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                }
                finally {
                    if (executor != null) {
                        executor.shutdown();
                    }
                }
                this.installedDistribution = new InstalledDistribution(installDir, this.getDisplayName(), this.getDisplayName());
            }
            return this.installedDistribution.getToolingImplementationClasspath(progressLoggerFactory, userHomeDir, cancellationToken);
        }
    }

    private static class InstalledDistribution
    implements Distribution {
        private final File gradleHomeDir;
        private final String displayName;
        private final String locationDisplayName;

        public InstalledDistribution(File gradleHomeDir, String displayName, String locationDisplayName) {
            this.gradleHomeDir = gradleHomeDir;
            this.displayName = displayName;
            this.locationDisplayName = locationDisplayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, File userHomeDir, BuildCancellationToken cancellationToken) {
            ProgressLogger progressLogger = progressLoggerFactory.newOperation(DistributionFactory.class);
            progressLogger.setDescription("Validate distribution");
            progressLogger.started();
            try {
                ClassPath classPath = this.getToolingImpl();
                return classPath;
            }
            finally {
                progressLogger.completed();
            }
        }

        private ClassPath getToolingImpl() {
            if (!this.gradleHomeDir.exists()) {
                throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.locationDisplayName));
            }
            if (!this.gradleHomeDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s is not a directory.", this.locationDisplayName));
            }
            File libDir = new File(this.gradleHomeDir, "lib");
            if (!libDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s does not appear to contain a Gradle distribution.", this.locationDisplayName));
            }
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (File file : libDir.listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                files.add(file);
            }
            return new DefaultClassPath(files);
        }
    }

    private static class ProgressReportingDownload
    implements IDownload {
        private final ProgressLoggerFactory progressLoggerFactory;

        private ProgressReportingDownload(ProgressLoggerFactory progressLoggerFactory) {
            this.progressLoggerFactory = progressLoggerFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void download(URI address, File destination) throws Exception {
            ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DistributionFactory.class);
            progressLogger.setDescription(String.format("Download %s", address));
            progressLogger.started();
            try {
                new Download(new Logger(false), "Gradle Tooling API", GradleVersion.current().getVersion()).download(address, destination);
            }
            finally {
                progressLogger.completed();
            }
        }
    }
}

