/**
 * Entry point for the TypeScript plugin
 */
"use strict";
var service_loader_1 = require("./service-loader");
var ts_session_1 = require("./ts-session");
var logger_impl_1 = require("./logger-impl");
var out_path_process_1 = require("./out-path-process");
var TypeScriptLanguagePlugin = (function () {
    function TypeScriptLanguagePlugin(state) {
        var loggerImpl = logger_impl_1.createLoggerFromEnv();
        var serviceInfo = service_loader_1.getService(state.serverFolderPath);
        var serviceContext = serviceInfo.context;
        var serverFilePath = serviceInfo.serverFilePath;
        var ts_impl = serviceContext.ts;
        overrideSysDefaults(ts_impl, serverFilePath);
        var commonDefaultCommandLine = state.hasManualParams && state.commandLineArguments ?
            ts_impl.parseCommandLine(state.commandLineArguments) :
            null;
        var commonDefaultOptions = null;
        if (commonDefaultCommandLine != null) {
            commonDefaultOptions = commonDefaultCommandLine.options;
        }
        var pathProcessor = null;
        if (state.hasManualParams && state.outPath) {
            pathProcessor = out_path_process_1.getPathProcessor(ts_impl, state);
        }
        var mainFile = null;
        if (state.hasManualParams && state.mainFilePath) {
            mainFile = state.mainFilePath;
        }
        this._session = ts_session_1.getSession(ts_impl, loggerImpl, commonDefaultOptions, pathProcessor, mainFile);
        this.readyMessage = { version: ts_impl.version };
    }
    TypeScriptLanguagePlugin.prototype.onMessage = function (p) {
        this._session.onMessage(p);
    };
    return TypeScriptLanguagePlugin;
}());
var TypeScriptLanguagePluginFactory = (function () {
    function TypeScriptLanguagePluginFactory() {
    }
    TypeScriptLanguagePluginFactory.prototype.create = function (state) {
        var typeScriptLanguagePlugin = new TypeScriptLanguagePlugin(state);
        return {
            languagePlugin: typeScriptLanguagePlugin,
            readyMessage: typeScriptLanguagePlugin.readyMessage
        };
    };
    return TypeScriptLanguagePluginFactory;
}());
function overrideSysDefaults(ts_impl, serverFolderPath) {
    var pending = [];
    var canWrite = true;
    function writeMessage(s) {
        if (!canWrite) {
            pending.push(s);
        }
        else {
            canWrite = false;
            process.stdout.write(new Buffer(s, "utf8"), setCanWriteFlagAndWriteMessageIfNecessary);
        }
    }
    function setCanWriteFlagAndWriteMessageIfNecessary() {
        canWrite = true;
        if (pending.length) {
            writeMessage(pending.shift());
        }
    }
    // Override sys.write because fs.writeSync is not reliable on Node 4
    ts_impl.sys.write = function (s) { return writeMessage(s); };
    //ts 2.0 compatibility
    ts_impl.sys.setTimeout = setTimeout;
    ts_impl.sys.clearTimeout = clearTimeout;
    ts_impl.sys.getExecutingFilePath = function () {
        return serverFolderPath;
    };
}
var typescriptLanguagePluginFactory = new TypeScriptLanguagePluginFactory();
exports.typescriptLanguagePluginFactory = typescriptLanguagePluginFactory;
