"use strict";
function initCommandNames(TypeScriptCommandNames) {
    TypeScriptCommandNames.IDEChangeFiles = "ideChangeFiles";
    TypeScriptCommandNames.IDECompile = "ideCompile";
    TypeScriptCommandNames.IDEGetErrors = "ideGetErr";
    TypeScriptCommandNames.IDEGetAllErrors = "ideGetAllErr";
    TypeScriptCommandNames.IDECompletions = "ideCompletions";
    TypeScriptCommandNames.IDEGetMainFileErrors = "ideGetMainFileErr";
    TypeScriptCommandNames.IDEGetProjectErrors = "ideGetProjectErr";
    if (TypeScriptCommandNames.ReloadProjects == undefined) {
        TypeScriptCommandNames.ReloadProjects = "reloadProjects";
    }
}
exports.initCommandNames = initCommandNames;
function isTypeScript15(ts_impl) {
    return ts_impl.version && (ts_impl.version == "1.5" || ts_impl.version.indexOf("1.5.") == 0);
}
exports.isTypeScript15 = isTypeScript15;
function isTypeScript16(ts_impl) {
    return ts_impl.version && (ts_impl.version == "1.6" || ts_impl.version.indexOf("1.6.") == 0);
}
exports.isTypeScript16 = isTypeScript16;
function copyOptionsWithResolvedFilesWithoutExtensions(configFileToProjectOptions, ts_impl) {
    function getBaseFileName(path) {
        if (path === undefined) {
            return undefined;
        }
        var i = path.lastIndexOf(ts_impl.directorySeparator);
        return i < 0 ? path : path.substring(i + 1);
    }
    if (!configFileToProjectOptions || !configFileToProjectOptions.projectOptions) {
        return configFileToProjectOptions;
    }
    var projectOptions = configFileToProjectOptions.projectOptions;
    var files = projectOptions.files;
    if (!files) {
        return configFileToProjectOptions;
    }
    var compilerOptions = projectOptions.compilerOptions;
    var extensions = ts_impl.getSupportedExtensions(compilerOptions);
    var newFiles = [];
    var hasOverrides = false;
    l: for (var _i = 0, files_1 = files; _i < files_1.length; _i++) {
        var file = files_1[_i];
        var fileName = getBaseFileName(file);
        for (var _a = 0, extensions_1 = extensions; _a < extensions_1.length; _a++) {
            var extension = extensions_1[_a];
            if (fileName.lastIndexOf(extension) > 0) {
                newFiles.push(file);
                continue l;
            }
        }
        for (var _b = 0, extensions_2 = extensions; _b < extensions_2.length; _b++) {
            var extension = extensions_2[_b];
            if (this.host.fileExists(file + extension)) {
                hasOverrides = true;
                newFiles.push(file + extension);
                continue l;
            }
        }
        newFiles.push(file);
    }
    if (!hasOverrides) {
        return configFileToProjectOptions;
    }
    var newOptions = {
        succeeded: configFileToProjectOptions.succeeded,
        projectOptions: {
            compilerOptions: compilerOptions,
            files: newFiles,
            wildcardDirectories: projectOptions.wildcardDirectories,
            compileOnSave: projectOptions.compileOnSave
        }
    };
    if (configFileToProjectOptions.error) {
        newOptions.error = configFileToProjectOptions.error;
    }
    if (configFileToProjectOptions.errors) {
        newOptions.errors = configFileToProjectOptions.errors;
    }
    return newOptions;
}
exports.copyOptionsWithResolvedFilesWithoutExtensions = copyOptionsWithResolvedFilesWithoutExtensions;
function appendProjectErrors(result, processedProjects, projectErrors, empty, ts_impl) {
    for (var projectName in projectErrors) {
        if (projectErrors.hasOwnProperty(projectName)) {
            var processedProjectErrors = projectErrors[projectName];
            if (processedProjectErrors && processedProjectErrors.length > 0) {
                if (empty || processedProjects[projectName]) {
                    var diagnosticBody = {
                        file: projectName,
                        diagnostics: processedProjectErrors
                    };
                    result = [diagnosticBody].concat(result);
                }
            }
        }
    }
    return result;
}
exports.appendProjectErrors = appendProjectErrors;
function isFunctionKind(kind) {
    return kind == "method" ||
        kind == "local function" ||
        kind == "function" ||
        kind == "call" ||
        kind == "construct";
}
exports.isFunctionKind = isFunctionKind;
