/**
 * Extensions for typescript server protocol
 * Provides new messages / fields
 */
declare namespace ts {
    /**
     * expose core api
     */
    export function normalizePath(path:string):string;
}

/**
 * see TypeScriptServiceInitialStateObject
 */
interface TypeScriptPluginState extends PluginState {
    serverFolderPath:string;

    //deprecated parameters but we need it for back-compatibility
    hasManualParams:boolean;
    outPath?:string;
    projectPath?:string;
    commandLineArguments?:string[];
    mainFilePath?:string;
}

declare namespace ts.server.CommandNames {
    export var IDEChangeFiles;
    export var IDECompile;
    export var IDEGetErrors;
    export var IDEGetAllErrors;
    export var IDEGetMainFileErrors;
    export var IDEGetProjectErrors;
    export var IDECompletions;
}

declare namespace ts.server.protocol {

    /**
     *  Extend request by adding config file relates to the file
     */
    export interface OpenRequestArgs extends FileRequestWithConfigArgs {

    }

    export interface FileRequestWithConfigArgs extends FileRequestArgs {
        tsConfig?:string;
    }

    export interface IDEUpdateFilesRequest extends Request {
        arguments:IDEUpdateFilesContentArgs;
    }

    export interface IDEUpdateFilesContentArgs {
        /**
         * map filepath -> new content
         */
        files:{
            [name:string]:string;
        }

        filesToReloadContentFromDisk:string[];
    }

    export interface IDECompileFileRequest extends Request {

        /**
         * path to typescript file or ts config
         */
        arguments:IDECompileFileRequestArgs;
    }



    export interface IDECompileFileRequestArgs extends FileRequestWithConfigArgs {
        includeErrors:boolean;
        force?:boolean

        //deprecated parameters but we need it for back-compatibility
        contentRootForMacro?:string;
        sourceRootForMacro?:string;
    }

    export type IDEBodyDiagnostics = {
        generatedFiles:string[],
        infos:DiagnosticEventBody[]
    }

    export interface IDECompileResponse extends Response {
        body:IDEBodyDiagnostics
    }

    export interface IDEGetErrorRequest extends Request {
        arguments:GeterrRequestArgs;
    }


    export interface IDECompletionsRequest extends FileLocationRequest {
        arguments:CompletionsRequestArgs;
    }

    export interface IDECompletionResponse extends Response {
        body?:CompletionEntryDetails[];
    }
}


declare namespace ts.server {
    interface ProjectOptions {
        //todo remove if ts2.0 services is used
        wildcardDirectories?: any;

        compileOnSave?:boolean
    }
}