import {ProjectResult} from "./ts-session";
import Project = ts.server.Project;
export function initCommandNames(TypeScriptCommandNames: typeof ts.server.CommandNames) {
    TypeScriptCommandNames.IDEChangeFiles = "ideChangeFiles";
    TypeScriptCommandNames.IDECompile = "ideCompile";
    TypeScriptCommandNames.IDEGetErrors = "ideGetErr";
    TypeScriptCommandNames.IDEGetAllErrors = "ideGetAllErr";
    TypeScriptCommandNames.IDECompletions = "ideCompletions";
    TypeScriptCommandNames.IDEGetMainFileErrors = "ideGetMainFileErr";
    TypeScriptCommandNames.IDEGetProjectErrors = "ideGetProjectErr";
    if (TypeScriptCommandNames.ReloadProjects == undefined) {
        (<any>TypeScriptCommandNames).ReloadProjects = "reloadProjects";
    }
}

export function isTypeScript15(ts_impl: typeof ts) {
    return ts_impl.version && (ts_impl.version == "1.5" || ts_impl.version.indexOf("1.5.") == 0)
}

export function isTypeScript16(ts_impl: typeof ts) {
    return ts_impl.version && (ts_impl.version == "1.6" || ts_impl.version.indexOf("1.6.") == 0)
}


export function copyOptionsWithResolvedFilesWithoutExtensions(configFileToProjectOptions: ProjectResult, ts_impl): ProjectResult {
    function getBaseFileName(path) {
        if (path === undefined) {
            return undefined;
        }
        let i = path.lastIndexOf(ts_impl.directorySeparator);
        return i < 0 ? path : path.substring(i + 1);
    }


    if (!configFileToProjectOptions || !configFileToProjectOptions.projectOptions) {
        return configFileToProjectOptions;
    }
    let projectOptions = configFileToProjectOptions.projectOptions;
    let files = projectOptions.files;

    if (!files) {
        return configFileToProjectOptions;
    }


    let compilerOptions = projectOptions.compilerOptions;
    let extensions: string[] = ts_impl.getSupportedExtensions(compilerOptions);
    let newFiles = [];

    let hasOverrides: boolean = false;
    l: for (let file of files) {
        let fileName = getBaseFileName(file);
        for (let extension of extensions) {
            if (fileName.lastIndexOf(extension) > 0) {
                newFiles.push(file);
                continue l;
            }
        }
        for (let extension of extensions) {
            if (this.host.fileExists(file + extension)) {
                hasOverrides = true;
                newFiles.push(file + extension);
                continue l;
            }
        }

        newFiles.push(file);
    }

    if (!hasOverrides) {
        return configFileToProjectOptions;
    }

    let newOptions: ProjectResult = {
        succeeded: configFileToProjectOptions.succeeded,
        projectOptions: {
            compilerOptions: compilerOptions,
            files: newFiles,
            wildcardDirectories: projectOptions.wildcardDirectories,
            compileOnSave: projectOptions.compileOnSave
        }
    }
    if (configFileToProjectOptions.error) {
        newOptions.error = configFileToProjectOptions.error;
    }
    if (configFileToProjectOptions.errors) {
        newOptions.errors = configFileToProjectOptions.errors;
    }


    return newOptions;
}

export function appendProjectErrors(
    result: ts.server.protocol.DiagnosticEventBody[],
    processedProjects: {[p: string]: Project },
    projectErrors: {[p: string]: ts.server.protocol.Diagnostic[]},
    empty:boolean,
    ts_impl
    ): ts.server.protocol.DiagnosticEventBody[] {

    for (let projectName in projectErrors) {
        if (projectErrors.hasOwnProperty(projectName)) {
            let processedProjectErrors = projectErrors[projectName];
            if (processedProjectErrors && processedProjectErrors.length > 0) {
                if (empty || processedProjects[projectName]) {
                    let diagnosticBody: ts.server.protocol.DiagnosticEventBody = {
                        file: projectName,
                        diagnostics: processedProjectErrors
                    }
                    result = [diagnosticBody].concat(result);
                }
            }
        }
    }

    return result;
}


export function isFunctionKind(kind: string) {
    return kind == "method" ||
        kind == "local function" ||
        kind == "function" ||
        kind == "call" ||
        kind == "construct";
}