/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.psi.css;

import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;

public interface CssTerm extends CssElement {
  CssTerm[] TERMS_EMPTY_ARRAY = new CssTerm[0];
  ArrayFactory<CssTerm> ARRAY_FACTORY = count -> count == 0 ? TERMS_EMPTY_ARRAY : new CssTerm[count];


  @NotNull CssTermType getTermType();
}
