// Copyright 2011 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * javascript files mentioned in traceur.js from traceur distribution need to be included in context.
 * @param [String] traceurCode
 */
function traceurTranslateString(traceurCode, filename) {
  var reporter = new traceur.util.ErrorReporter();
  var project = new traceur.semantics.symbols.Project("");
  var sourceFile = new traceur.syntax.SourceFile(filename, traceurCode);
  project.addFile(sourceFile);

  traceur.options.validate = false;
  traceur.options.freeVariableChecker = false;

  var results = traceur.codegeneration.Compiler.compile(reporter, project);
  if (reporter.hadError()) {
    return (allErrors !='') ? allErrors : "Traceur compiler caused an error during compilation. Please check source file syntax.";
  }

  var file = results.keys()[0];
  var tree = results.get(file);
  var result = traceur.codegeneration.ParseTreeWriter.write(tree, false);

  return result;
}


