/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentConfig;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3CloudAgent;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Pod;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Project;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Service;
import com.intellij.javaee.openshift.cloud.OS3ApplicationRuntime;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OS3ServerRuntimeInstance
extends CloudServerRuntimeInstance<OSDeploymentConfiguration, OS3CloudAgent, OSCloudConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)("#" + OS3ServerRuntimeInstance.class.getName()));
    private static final String SPECIFICS_MODULE_NAME = "OpenShift3Srv";
    private static final String SPECIFICS_JAR_PATH = "specifics/openShiftSpecifics.jar";
    private static final String POD_STATUS_FAILED = "Failed";

    public OS3ServerRuntimeInstance(RemoteServer<OSCloudConfiguration> server, ServerTaskExecutor taskExecutor, List<File> clientLibrary) throws Exception {
        super((CloudAgentConfigBase)server.getConfiguration(), taskExecutor, clientLibrary, Collections.emptyList(), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, OS3CloudAgent.class, "com.intellij.javaee.openshift.agent.cloud.OS3CloudAgentImpl");
    }

    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication application) {
        throw new UnsupportedOperationException();
    }

    protected List<CloudApplicationRuntime> getApplications() throws ServerRuntimeException {
        return (List)this.getAgentTaskExecutor().execute(() -> {
            ArrayList<CloudApplicationRuntime> result = new ArrayList<CloudApplicationRuntime>();
            this.collectProjectsRuntime(result);
            return result;
        });
    }

    private void collectProjectsRuntime(List<CloudApplicationRuntime> result) {
        for (OS3Project project : ((OS3CloudAgent)this.getAgent()).getApplications()) {
            OS3ApplicationRuntime projectRuntime = new OS3ApplicationRuntime(this.getTaskExecutor(), this.getAgentTaskExecutor(), project.getName(), null, new DeploymentStatus(AllIcons.Actions.GroupByPackage, "Project", false));
            this.collectServices(result, project, projectRuntime);
            result.add(projectRuntime);
        }
    }

    private void collectServices(List<CloudApplicationRuntime> result, OS3Project project, OS3ApplicationRuntime projectRuntime) {
        for (OS3Service service : project.getServices()) {
            OS3ApplicationRuntime serviceRuntime = new OS3ApplicationRuntime(this.getTaskExecutor(), this.getAgentTaskExecutor(), service.getServiceName(), projectRuntime, new DeploymentStatus(AllIcons.Actions.GroupByModuleGroup, "Service", false));
            result.add(serviceRuntime);
            this.collectPods(result, service, serviceRuntime);
        }
    }

    private void collectPods(List<CloudApplicationRuntime> result, OS3Service service, OS3ApplicationRuntime serviceRuntime) {
        for (OS3Pod pod : service.getPods()) {
            String podStatus = pod.getStatus();
            Icon statusIcon = podStatus != null && podStatus.contains(POD_STATUS_FAILED) ? AllIcons.General.BalloonError : AllIcons.Actions.GroupByModule;
            OS3ApplicationRuntime podRuntime = new OS3ApplicationRuntime(this.getTaskExecutor(), this.getAgentTaskExecutor(), pod.getName(), serviceRuntime, new DeploymentStatus(statusIcon, StringUtil.notNullize((String)podStatus, (String)"Pod"), false));
            result.add(podRuntime);
        }
    }

    public void deploy(@NotNull DeploymentTask<OSDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/javaee/openshift/cloud/OS3ServerRuntimeInstance", "deploy"));
        }
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/javaee/openshift/cloud/OS3ServerRuntimeInstance", "deploy"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/openshift/cloud/OS3ServerRuntimeInstance", "deploy"));
        }
        throw new UnsupportedOperationException();
    }

    public void disconnect() {
    }

    public void connect(ServerConnector.ConnectionCallback<OSDeploymentConfiguration> callback) {
        this.doConnect(callback);
    }

    private void doConnect(final ServerConnector.ConnectionCallback<OSDeploymentConfiguration> callback) {
        this.getAgentTaskExecutor().execute(() -> {
            ((OS3CloudAgent)this.getAgent()).connect((OSCloudAgentConfig)this.getConfiguration(), (CloudAgentErrorHandler)this.getAgentTaskExecutor(), new CloudAgentLogger(){

                public void debugEx(Exception e) {
                    LOG.debug((Throwable)e);
                }

                public void debug(String message) {
                    LOG.debug(message);
                }
            });
            return null;
        }, new CallbackWrapper(){

            public void onSuccess(Object result) {
                callback.connected((ServerRuntimeInstance)OS3ServerRuntimeInstance.this);
            }

            public void onError(String message) {
                callback.errorOccurred(message);
            }
        });
    }
}

