/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AopPsiTypePattern {
    public static final AopPsiTypePattern FALSE = new AopPsiTypePattern(){

        @Override
        public boolean accepts(@NotNull PsiType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/AopPsiTypePattern$1", "accepts"));
            }
            return false;
        }

        @Override
        @NotNull
        public PointcutMatchDegree canBeAssignableFrom(@NotNull PsiType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/AopPsiTypePattern$1", "canBeAssignableFrom"));
            }
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopPsiTypePattern$1", "canBeAssignableFrom"));
            }
            return pointcutMatchDegree;
        }
    };
    public static final AopPsiTypePattern TRUE = new AopPsiTypePattern(){

        @Override
        public boolean accepts(@NotNull PsiType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/AopPsiTypePattern$2", "accepts"));
            }
            return true;
        }

        @Override
        public boolean accepts(@NotNull String qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/aop/psi/AopPsiTypePattern$2", "accepts"));
            }
            return true;
        }

        @Override
        @NotNull
        public PointcutMatchDegree canBeAssignableFrom(@NotNull PsiType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/AopPsiTypePattern$2", "canBeAssignableFrom"));
            }
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.TRUE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopPsiTypePattern$2", "canBeAssignableFrom"));
            }
            return pointcutMatchDegree;
        }
    };

    public abstract boolean accepts(@NotNull PsiType var1);

    public boolean accepts(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/aop/psi/AopPsiTypePattern", "accepts"));
        }
        return false;
    }

    @NotNull
    public PointcutMatchDegree canBeAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/AopPsiTypePattern", "canBeAssignableFrom"));
        }
        PointcutMatchDegree pointcutMatchDegree = this.canBeAssignableFrom(type, (Set<PsiType>)new THashSet());
        if (pointcutMatchDegree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopPsiTypePattern", "canBeAssignableFrom"));
        }
        return pointcutMatchDegree;
    }

    private PointcutMatchDegree canBeAssignableFrom(PsiType type, Set<PsiType> visited) {
        visited.add(type);
        if (this.accepts(type)) {
            return PointcutMatchDegree.TRUE;
        }
        boolean maybe = false;
        for (PsiType superType : AopPsiTypePattern.getSuperTypes(type)) {
            if (visited.contains(superType)) continue;
            PointcutMatchDegree degree = this.canBeAssignableFrom(superType, visited);
            if (degree == PointcutMatchDegree.TRUE) {
                return degree;
            }
            maybe = degree == PointcutMatchDegree.MAYBE;
        }
        return maybe ? PointcutMatchDegree.MAYBE : PointcutMatchDegree.FALSE;
    }

    private static PsiType[] getSuperTypes(PsiType type) {
        if (type instanceof PsiWildcardType && ((PsiWildcardType)type).getBound() == null) {
            return PsiType.EMPTY_ARRAY;
        }
        return type.getSuperTypes();
    }

    protected static boolean processSubPackages(PsiPackage pkg, Processor<PsiPackage> processor) {
        if (!processor.process((Object)pkg)) {
            return false;
        }
        for (PsiPackage aPackage : pkg.getSubPackages()) {
            if (AopPsiTypePattern.processSubPackages(aPackage, processor)) continue;
            return false;
        }
        return true;
    }

    public static PointcutMatchDegree accepts(AopTypeExpression expression, PsiType psiType) {
        return AopPsiTypePattern.accepts(expression.getPatterns(), psiType);
    }

    public static PointcutMatchDegree accepts(Collection<AopPsiTypePattern> patterns, PsiType psiType) {
        for (AopPsiTypePattern pattern : patterns) {
            if (!pattern.accepts(psiType)) continue;
            return PointcutMatchDegree.TRUE;
        }
        return PointcutMatchDegree.FALSE;
    }
}

