/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit3.TestRunnerUtil;
import com.intellij.junit4.JUnit45ClassesRequestBuilder;
import com.intellij.junit4.JUnit46ClassesRequestBuilder;
import com.intellij.junit4.JUnit4ClassesRequestBuilder;
import com.intellij.junit4.JUnit4ReflectionUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.IgnoredBuilder;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.internal.requests.ClassRequest;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;

public class JUnit4TestRunnerUtil {
    private static final ResourceBundle ourBundle = ResourceBundle.getBundle("RuntimeBundle");
    static /* synthetic */ Class class$org$junit$runner$RunWith;
    static /* synthetic */ Class class$org$junit$runners$Parameterized;
    static /* synthetic */ Class class$org$junit$Ignore;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$com$intellij$junit4$JUnit4TestRunnerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Request buildRequest(String[] suiteClassNames, final String name, boolean notForked) {
        if (suiteClassNames.length == 0) {
            return null;
        }
        Vector result = new Vector();
        for (int i = 0; i < suiteClassNames.length; ++i) {
            RunWith clazzAnnotation;
            Request request;
            Class clazz;
            String suiteClassName = suiteClassNames[i];
            if (suiteClassName.charAt(0) == '@') {
                try {
                    final HashMap<String, HashSet<String>> classMethods = new HashMap<String, HashSet<String>>();
                    BufferedReader reader = new BufferedReader(new FileReader(suiteClassName.substring(1)));
                    try {
                        Request allClasses;
                        HashSet<String> methodNames;
                        String line;
                        Class category;
                        String packageName = reader.readLine();
                        if (packageName == null) {
                            Request request2 = null;
                            return request2;
                        }
                        String categoryName = reader.readLine();
                        Class clazz2 = category = categoryName != null && categoryName.length() > 0 ? JUnit4TestRunnerUtil.loadTestClass(categoryName) : null;
                        while ((line = reader.readLine()) != null) {
                            String className = line;
                            int idx = line.indexOf(44);
                            if (idx != -1) {
                                className = line.substring(0, idx);
                                methodNames = (HashSet<String>)classMethods.get(className);
                                if (methodNames == null) {
                                    methodNames = new HashSet<String>();
                                    classMethods.put(className, methodNames);
                                }
                                methodNames.add(line.substring(idx + 1));
                            }
                            JUnit4TestRunnerUtil.appendTestClass(result, className);
                        }
                        String suiteName = packageName.length() == 0 ? "<default package>" : packageName;
                        Class[] classes = JUnit4TestRunnerUtil.getArrayOfClasses(result);
                        if (classes.length == 0) {
                            System.out.println(TestRunnerUtil.testsFoundInPackageMesage(0, suiteName));
                            methodNames = null;
                            return methodNames;
                        }
                        try {
                            Class.forName("org.junit.runner.Computer");
                            allClasses = JUnit46ClassesRequestBuilder.getClassesRequest(suiteName, classes, classMethods, category);
                        }
                        catch (ClassNotFoundException e) {
                            allClasses = JUnit4TestRunnerUtil.getClassRequestsUsing44API(suiteName, classes);
                        }
                        catch (NoSuchMethodError e) {
                            allClasses = JUnit4TestRunnerUtil.getClassRequestsUsing44API(suiteName, classes);
                        }
                        Request request3 = classMethods.isEmpty() ? allClasses : allClasses.filterWith(new Filter(){

                            public boolean shouldRun(Description description) {
                                if (description.isTest()) {
                                    int idx;
                                    RunWith classAnnotation;
                                    Set methods = (Set)classMethods.get(JUnit4ReflectionUtil.getClassName(description));
                                    if (methods == null) {
                                        return true;
                                    }
                                    String methodName = JUnit4ReflectionUtil.getMethodName(description);
                                    if (methods.contains(methodName)) {
                                        return true;
                                    }
                                    if (name != null) {
                                        return methodName.endsWith(name) && methods.contains(methodName.substring(0, methodName.length() - name.length()));
                                    }
                                    Class testClass = description.getTestClass();
                                    if (testClass != null && (classAnnotation = (RunWith)testClass.getAnnotation(class$org$junit$runner$RunWith == null ? (class$org$junit$runner$RunWith = JUnit4TestRunnerUtil.class$("org.junit.runner.RunWith")) : class$org$junit$runner$RunWith)) != null && (class$org$junit$runners$Parameterized == null ? (class$org$junit$runners$Parameterized = JUnit4TestRunnerUtil.class$("org.junit.runners.Parameterized")) : class$org$junit$runners$Parameterized).isAssignableFrom(classAnnotation.value()) && (idx = methodName.indexOf("[")) > -1) {
                                        return methods.contains(methodName.substring(0, idx));
                                    }
                                    return false;
                                }
                                return true;
                            }

                            public String describe() {
                                return "Tests";
                            }
                        });
                        return request3;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                    continue;
                }
            }
            int index = suiteClassName.indexOf(44);
            if (index != -1) {
                clazz = JUnit4TestRunnerUtil.loadTestClass(suiteClassName.substring(0, index));
                final String methodName = suiteClassName.substring(index + 1);
                RunWith clazzAnnotation2 = (RunWith)clazz.getAnnotation(class$org$junit$runner$RunWith == null ? (class$org$junit$runner$RunWith = JUnit4TestRunnerUtil.class$("org.junit.runner.RunWith")) : class$org$junit$runner$RunWith);
                Description testMethodDescription = Description.createTestDescription((Class)clazz, (String)methodName);
                if (clazzAnnotation2 == null) {
                    try {
                        Method method = clazz.getMethod(methodName, null);
                        if (method != null && notForked && (method.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestRunnerUtil.class$("org.junit.Ignore")) : class$org$junit$Ignore) != null || clazz.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestRunnerUtil.class$("org.junit.Ignore")) : class$org$junit$Ignore) != null)) {
                            Request classRequest = JUnit4TestRunnerUtil.createIgnoreIgnoredClassRequest(clazz, true);
                            final Filter ignoredTestFilter = Filter.matchMethodDescription((Description)testMethodDescription);
                            return classRequest.filterWith(new Filter(){

                                public boolean shouldRun(Description description) {
                                    return ignoredTestFilter.shouldRun(description);
                                }

                                public String describe() {
                                    return "Ignored " + methodName;
                                }
                            });
                        }
                    }
                    catch (Exception method) {}
                } else {
                    Request request4 = JUnit4TestRunnerUtil.getParameterizedRequest(name, methodName, clazz, clazzAnnotation2);
                    if (request4 != null) {
                        return request4;
                    }
                }
                try {
                    if (clazz.getMethod("suite", new Class[0]) != null && !methodName.equals("suite")) {
                        return Request.classWithoutSuiteMethod((Class)clazz).filterWith(testMethodDescription);
                    }
                }
                catch (Throwable request4) {
                    // empty catch block
                }
                try {
                    final Filter methodFilter = Filter.matchMethodDescription((Description)testMethodDescription);
                    return Request.aClass((Class)clazz).filterWith(new Filter(){

                        public boolean shouldRun(Description description) {
                            if (description.isTest() && description.getDisplayName().startsWith("warning(junit.framework.TestSuite$")) {
                                return true;
                            }
                            return methodFilter.shouldRun(description);
                        }

                        public String describe() {
                            return methodFilter.describe();
                        }
                    });
                }
                catch (NoSuchMethodError e) {
                    return Request.method((Class)clazz, (String)methodName);
                }
            }
            if (name != null && suiteClassNames.length == 1 && (clazz = JUnit4TestRunnerUtil.loadTestClass(suiteClassName)) != null && (request = JUnit4TestRunnerUtil.getParameterizedRequest(name, null, clazz, clazzAnnotation = (RunWith)clazz.getAnnotation(class$org$junit$runner$RunWith == null ? JUnit4TestRunnerUtil.class$("org.junit.runner.RunWith") : class$org$junit$runner$RunWith))) != null) {
                return request;
            }
            JUnit4TestRunnerUtil.appendTestClass(result, suiteClassName);
        }
        if (result.size() != 1) return Request.classes((Class[])JUnit4TestRunnerUtil.getArrayOfClasses(result));
        Class clazz = (Class)result.get(0);
        try {
            if (clazz.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestRunnerUtil.class$("org.junit.Ignore")) : class$org$junit$Ignore) == null) return Request.aClass((Class)clazz);
            return JUnit4TestRunnerUtil.createIgnoreIgnoredClassRequest(clazz, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Request.aClass((Class)clazz);
    }

    private static Request getParameterizedRequest(final String parameterString, final String methodName, Class clazz, RunWith clazzAnnotation) {
        Class runnerClass;
        if (clazzAnnotation == null) {
            return null;
        }
        if ((class$org$junit$runners$Parameterized == null ? (class$org$junit$runners$Parameterized = JUnit4TestRunnerUtil.class$("org.junit.runners.Parameterized")) : class$org$junit$runners$Parameterized).isAssignableFrom(runnerClass = clazzAnnotation.value())) {
            try {
                Class.forName("org.junit.runners.BlockJUnit4ClassRunner");
                Constructor runnerConstructor = runnerClass.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = JUnit4TestRunnerUtil.class$("java.lang.Class")) : class$java$lang$Class);
                return Request.runner((Runner)((Runner)runnerConstructor.newInstance(clazz))).filterWith(new Filter(){

                    public boolean shouldRun(Description description) {
                        String descriptionMethodName = description.getMethodName();
                        if (parameterString != null && descriptionMethodName != null && !descriptionMethodName.endsWith(parameterString)) {
                            return false;
                        }
                        return methodName == null || descriptionMethodName == null || descriptionMethodName.startsWith(methodName + "[") || descriptionMethodName.equals(methodName);
                    }

                    public String describe() {
                        if (parameterString == null) {
                            return methodName + " with any parameter";
                        }
                        if (methodName == null) {
                            return "Parameter " + parameterString + " for any method";
                        }
                        return methodName + " with parameter " + parameterString;
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static Request createIgnoreIgnoredClassRequest(final Class clazz, boolean recursively) throws ClassNotFoundException {
        Class.forName("org.junit.runners.BlockJUnit4ClassRunner");
        return new ClassRequest(clazz){

            public Runner getRunner() {
                try {
                    return new AllDefaultPossibilitiesBuilder(true){

                        protected IgnoredBuilder ignoredBuilder() {
                            return new IgnoredBuilder(){

                                public Runner runnerForClass(Class testClass) {
                                    return null;
                                }
                            };
                        }

                        protected JUnit4Builder junit4Builder() {
                            return new JUnit4Builder(){

                                public Runner runnerForClass(Class testClass) throws Throwable {
                                    return new BlockJUnit4ClassRunner(testClass){

                                        protected boolean isIgnored(FrameworkMethod child) {
                                            return false;
                                        }
                                    };
                                }
                            };
                        }
                    }.runnerForClass(clazz);
                }
                catch (Throwable throwable) {
                    return super.getRunner();
                }
            }
        };
    }

    private static Request getClassRequestsUsing44API(String suiteName, Class[] classes) {
        Request allClasses;
        try {
            Class.forName("org.junit.internal.requests.ClassesRequest");
            allClasses = JUnit4ClassesRequestBuilder.getClassesRequest(suiteName, classes);
        }
        catch (ClassNotFoundException e1) {
            allClasses = JUnit45ClassesRequestBuilder.getClassesRequest(suiteName, classes);
        }
        return allClasses;
    }

    private static void appendTestClass(Vector result, String className) {
        Class aClass = JUnit4TestRunnerUtil.loadTestClass(className);
        if (!result.contains(aClass)) {
            result.addElement(aClass);
        }
    }

    private static Class[] getArrayOfClasses(Vector result) {
        Class[] classes = new Class[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            classes[i] = (Class)result.get(i);
        }
        return classes;
    }

    private static Class loadTestClass(String suiteClassName) {
        try {
            return Class.forName(suiteClassName, false, (class$com$intellij$junit4$JUnit4TestRunnerUtil == null ? (class$com$intellij$junit4$JUnit4TestRunnerUtil = JUnit4TestRunnerUtil.class$("com.intellij.junit4.JUnit4TestRunnerUtil")) : class$com$intellij$junit4$JUnit4TestRunnerUtil).getClassLoader());
        }
        catch (ClassNotFoundException e) {
            String clazz = e.getMessage();
            if (clazz == null) {
                clazz = suiteClassName;
            }
            System.err.print(MessageFormat.format(ourBundle.getString("junit.class.not.found"), clazz));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format(ourBundle.getString("junit.cannot.instantiate.tests"), e.toString()));
            System.exit(1);
        }
        return null;
    }

    public static String testsFoundInPackageMesage(int testCount, String name) {
        return MessageFormat.format(ourBundle.getString("tests.found.in.package"), new Integer(testCount), name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

