/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalFileDeploymentSource
implements DeploymentSource {
    private final File myFile;

    public ExternalFileDeploymentSource(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/deployment/ExternalFileDeploymentSource", "<init>"));
        }
        this.myFile = file;
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/ExternalFileDeploymentSource", "getFile"));
        }
        return file;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFile.getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/ExternalFileDeploymentSource", "getFilePath"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/ExternalFileDeploymentSource", "getPresentableName"));
        }
        return string;
    }

    public Icon getIcon() {
        VirtualFile file = this.findVirtualFile();
        return file != null ? VirtualFilePresentation.getIcon((VirtualFile)file) : null;
    }

    @Nullable
    private VirtualFile findVirtualFile() {
        return LocalFileSystem.getInstance().findFileByIoFile(this.myFile);
    }

    public boolean isValid() {
        return this.myFile.exists();
    }

    public boolean isArchive() {
        return this.myFile.isFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalFileDeploymentSource)) {
            return false;
        }
        return FileUtil.filesEqual((File)this.myFile, (File)((ExternalFileDeploymentSource)o).myFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myFile);
    }

    @NotNull
    public DeploymentSourceType<?> getType() {
        throw new UnsupportedOperationException("'getType' not implemented in " + this.getClass().getName());
    }
}

