/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment.ui.actions;

import com.intellij.javaee.deployment.ArtifactDeploymentSource;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.ui.DeploymentSettingsPanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.ui.AnActionButton;
import com.intellij.util.IconUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OpenArtifactEditorAction
extends AnActionButton {
    private final DeploymentSettingsPanel myPanel;

    public OpenArtifactEditorAction(DeploymentSettingsPanel deploymentSettingsPanel) {
        super("Edit Artifact", null, IconUtil.getEditIcon());
        this.myPanel = deploymentSettingsPanel;
    }

    public boolean isEnabled() {
        return this.getSelectedArtifact() != null;
    }

    @Nullable
    private Artifact getSelectedArtifact() {
        DeploymentSource source;
        List<DeploymentSource> sources = this.myPanel.getSelectedSources();
        if (sources.size() == 1 && (source = sources.get(0)) instanceof ArtifactDeploymentSource) {
            return ((ArtifactDeploymentSource)source).getArtifact();
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e) {
        ModulesConfigurator.showArtifactSettings((Project)this.myPanel.getProject(), (Artifact)this.getSelectedArtifact());
        this.myPanel.updateDeploymentModels();
    }
}

