/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributionModel;
import com.intellij.javaee.ui.packaging.ExplodedEarArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedEjbArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeFrameworkSupportContributionModelImpl
implements JavaeeFrameworkSupportContributionModel {
    private ModifiableArtifactModel myModifiableArtifactModel;
    private final JavaeeFrameworkSupportInfoCollector myCollector;
    private final FrameworkSupportModel myFrameworkSupportModel;
    private final Module myModule;
    private final ModifiableRootModel myRootModel;

    public JavaeeFrameworkSupportContributionModelImpl(FrameworkSupportModel model, Module module, ModifiableRootModel rootModel, JavaeeFrameworkSupportInfoCollector collector) {
        this.myFrameworkSupportModel = model;
        this.myModule = module;
        this.myRootModel = rootModel;
        this.myCollector = collector;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myModule.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/facet/JavaeeFrameworkSupportContributionModelImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/facet/JavaeeFrameworkSupportContributionModelImpl", "getModule"));
        }
        return module;
    }

    @NotNull
    public ModifiableRootModel getRootModel() {
        ModifiableRootModel modifiableRootModel = this.myRootModel;
        if (modifiableRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/facet/JavaeeFrameworkSupportContributionModelImpl", "getRootModel"));
        }
        return modifiableRootModel;
    }

    public ModifiableArtifact getModifiableExplodedWarArtifact() {
        return this.getModifiableArtifact(this.getExplodedWarArtifact());
    }

    public ModifiableArtifact getModifiableExplodedEjbArtifact() {
        return this.getModifiableArtifact(this.getExplodedEjbArtifact());
    }

    public ModifiableArtifact getModifiableExplodedEarArtifact() {
        return this.getModifiableArtifact(this.getExplodedEarArtifact());
    }

    public Artifact getExplodedWarArtifact() {
        return this.myCollector.getArtifact((ArtifactType)ExplodedWarArtifactType.getInstance());
    }

    public Artifact getExplodedEarArtifact() {
        return this.myCollector.getArtifact((ArtifactType)ExplodedEarArtifactType.getInstance());
    }

    public Artifact getExplodedEjbArtifact() {
        return this.myCollector.getArtifact((ArtifactType)ExplodedEjbArtifactType.getInstance());
    }

    public CommonModel getRunConfiguration() {
        return this.myCollector.getRunConfiguration();
    }

    @Nullable
    private ModifiableArtifact getModifiableArtifact(Artifact artifact) {
        return artifact != null ? this.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(artifact) : null;
    }

    private ModifiableArtifactModel getOrCreateModifiableArtifactModel() {
        if (this.myModifiableArtifactModel == null) {
            this.myModifiableArtifactModel = ArtifactManager.getInstance((Project)this.getProject()).createModifiableModel();
        }
        return this.myModifiableArtifactModel;
    }

    @Nullable
    public <F extends Facet> F getFacet(FacetTypeId<F> id) {
        return (F)this.myCollector.getFacet(id);
    }

    public VirtualFile getIndexJspFile() {
        return this.myCollector.getIndexJspFile();
    }

    public boolean isFrameworkSelected(@NotNull @NonNls String providerId) {
        if (providerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerId", "com/intellij/javaee/facet/JavaeeFrameworkSupportContributionModelImpl", "isFrameworkSelected"));
        }
        return this.myFrameworkSupportModel.isFrameworkSelected(providerId);
    }

    public boolean isFacetFrameworkSelected(@NotNull @NonNls FacetTypeId<?> typeId) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/javaee/facet/JavaeeFrameworkSupportContributionModelImpl", "isFacetFrameworkSelected"));
        }
        return this.myFrameworkSupportModel.isFrameworkSelected(FacetBasedFrameworkSupportProvider.getProviderId(typeId));
    }

    public void commitModels() {
        if (this.myModifiableArtifactModel != null) {
            if (this.myModifiableArtifactModel.isModified()) {
                this.myModifiableArtifactModel.commit();
            } else {
                this.myModifiableArtifactModel.dispose();
            }
        }
    }
}

