/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

public abstract class FilteringIterator<T>
implements Iterator<T> {
    private final Iterator<T> outer;
    private T next;

    protected FilteringIterator(Iterator<T> outer) {
        this.outer = outer;
        this.next = this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        T element = this.next;
        this.next = this.getNext();
        return element;
    }

    @Override
    public void remove() {
        this.outer.remove();
    }

    protected abstract boolean matches(T var1);

    @Nullable
    private T getNext() {
        while (this.outer.hasNext()) {
            T element = this.outer.next();
            if (!this.matches(element)) continue;
            return element;
        }
        return null;
    }
}

