/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.structure;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.xml.XmlStructureViewBuilderProvider;
import com.intellij.javaee.model.xml.persistence.mapping.EmbeddableAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaStructureViewBuilderProvider
implements XmlStructureViewBuilderProvider {
    @Nullable
    public StructureViewBuilder createStructureViewBuilder(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jpa/model/structure/JpaStructureViewBuilderProvider", "createStructureViewBuilder"));
        }
        DomFileElement fileElement = DomManager.getDomManager((Project)file.getProject()).getFileElement(file, DomElement.class);
        if (fileElement == null || !PersistenceMappings.class.isInstance(fileElement.getRootElement())) {
            return null;
        }
        return DomService.getInstance().createSimpleStructureViewBuilder(file, (Function)((NotNullFunction)domElement -> {
            if (domElement instanceof PersistenceMappings || domElement instanceof PersistentObject || domElement instanceof PersistentAttribute || domElement instanceof PersistenceQuery) {
                return DomService.StructureViewMode.SHOW;
            }
            if (domElement instanceof EmbeddableAttributes) {
                return DomService.StructureViewMode.SHOW_CHILDREN;
            }
            return DomService.StructureViewMode.SKIP;
        }));
    }
}

