/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.artifact;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.packaging.GwtCompileOutputRelativePathSuggester;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.vaadin.framework.VaadinLibraryType;
import org.jetbrains.annotations.NotNull;

public class VaadinWidgetSetOutputRelativePathSuggester
extends GwtCompileOutputRelativePathSuggester {
    public boolean isEnabled(FrameworkSupportModel model) {
        return model.isFrameworkSelected("vaadin");
    }

    public boolean isEnabled(GwtFacet facet, PackagingElementResolvingContext context) {
        String sdkType = ((GwtFacetConfiguration)facet.getConfiguration()).getGwtSdkType();
        if ("Vaadin".equals(sdkType) || "Vaadin-Maven".equals(sdkType)) {
            return true;
        }
        CommonProcessors.FindProcessor<Library> processor = new CommonProcessors.FindProcessor<Library>(){

            protected boolean accept(Library library) {
                PersistentLibraryKind kind = ((LibraryEx)library).getKind();
                return VaadinLibraryType.getInstance().getKind().equals(kind);
            }
        };
        context.getModulesProvider().getRootModel(facet.getModule()).orderEntries().forEachLibrary((Processor)processor);
        return processor.isFound();
    }

    @NotNull
    public String getRelativeOutputPath() {
        if ("VAADIN/widgetsets" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/artifact/VaadinWidgetSetOutputRelativePathSuggester", "getRelativeOutputPath"));
        }
        return "VAADIN/widgetsets";
    }
}

