/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.i18n;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.gwt.i18n.GwtI18nUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtI18nManagerImpl
extends GwtI18nManager {
    private static final IProperty[] EMPTY_PROPERTIES_ARRAY = new IProperty[0];
    private static final PropertiesFile[] EMPTY_PROPERTIES_FILE_ARRAY = new PropertiesFile[0];
    private final PsiManager myPsiManager;
    private final Project myProject;

    public GwtI18nManagerImpl(PsiManager psiManager, Project project) {
        this.myProject = project;
        this.myPsiManager = psiManager;
    }

    private boolean isConstantsOrMessagesInterface(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "isConstantsOrMessagesInterface"));
        }
        if (!GwtFacet.isInModuleWithGwtFacet(this.myProject, GwtI18nManagerImpl.getOriginalContainingFile(aClass).getVirtualFile()) || !aClass.isInterface()) {
            return false;
        }
        return this.isConstantsInterface(aClass) || GwtI18nManagerImpl.isExtendingInterface(aClass, "com.google.gwt.i18n.client.Messages");
    }

    private static boolean isExtendingInterface(PsiClass aClass, String superInterfaceName) {
        return aClass.isInterface() && InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)superInterfaceName);
    }

    @Override
    public boolean isConstantsInterface(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "isConstantsInterface"));
        }
        return GwtI18nManagerImpl.isExtendingInterface(aClass, "com.google.gwt.i18n.client.Constants");
    }

    @Override
    public boolean isLocalizableInterface(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "isLocalizableInterface"));
        }
        return GwtI18nManagerImpl.isExtendingInterface(aClass, "com.google.gwt.i18n.client.LocalizableResource");
    }

    @Override
    @NotNull
    public PropertiesFile[] getPropertiesFiles(@NotNull PsiClass anInterface) {
        if (anInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anInterface", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "getPropertiesFiles"));
        }
        PsiFile containingFile = GwtI18nManagerImpl.getOriginalContainingFile(anInterface);
        PsiDirectory mainDirectory = containingFile.getContainingDirectory();
        if (mainDirectory == null || !this.isConstantsOrMessagesInterface(anInterface)) {
            if (EMPTY_PROPERTIES_FILE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "getPropertiesFiles"));
            }
            return EMPTY_PROPERTIES_FILE_ARRAY;
        }
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(mainDirectory);
        if (psiPackage == null) {
            if (EMPTY_PROPERTIES_FILE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "getPropertiesFiles"));
            }
            return EMPTY_PROPERTIES_FILE_ARRAY;
        }
        PsiDirectory[] directories = psiPackage.getDirectories(anInterface.getResolveScope());
        ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>();
        for (PsiDirectory directory : directories) {
            for (PsiFile psiFile : directory.getFiles()) {
                String interfaceName;
                PropertiesFile propertiesFile;
                String fileName;
                if (!(psiFile instanceof PropertiesFile) || !GwtI18nManagerImpl.isFileNameForInterfaceName(fileName = (propertiesFile = (PropertiesFile)psiFile).getName(), interfaceName = anInterface.getName())) continue;
                files.add(propertiesFile);
            }
        }
        PropertiesFile[] propertiesFileArray = files.toArray(new PropertiesFile[files.size()]);
        if (propertiesFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "getPropertiesFiles"));
        }
        return propertiesFileArray;
    }

    private static PsiFile getOriginalContainingFile(PsiClass anInterface) {
        return anInterface.getContainingFile().getOriginalFile();
    }

    private static boolean isFileNameForInterfaceName(@Nullable String fileName, @Nullable String interfaceName) {
        return fileName != null && interfaceName != null && (fileName.equals(interfaceName + "." + StdFileTypes.PROPERTIES.getDefaultExtension()) || StringUtil.startsWithConcatenation((String)fileName, (String[])new String[]{interfaceName, "_"}));
    }

    @Override
    @Nullable
    public PsiClass getPropertiesInterface(@NotNull PropertiesFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "getPropertiesInterface"));
        }
        String fileName = file.getName();
        PsiDirectory directory = file.getParent();
        GwtFacet facet = GwtFacet.findFacetBySourceFile(this.myProject, file.getVirtualFile());
        if (directory == null || facet == null) {
            return null;
        }
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (psiPackage == null) {
            return null;
        }
        for (PsiClass psiClass : psiPackage.getClasses(GlobalSearchScope.moduleWithDependenciesScope((Module)facet.getModule()))) {
            if (!GwtI18nManagerImpl.isFileNameForInterfaceName(fileName, psiClass.getName()) || !this.isConstantsOrMessagesInterface(psiClass)) continue;
            return psiClass;
        }
        return null;
    }

    @Override
    @NotNull
    public IProperty[] getProperties(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "getProperties"));
        }
        final PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            if (EMPTY_PROPERTIES_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "getProperties"));
            }
            return EMPTY_PROPERTIES_ARRAY;
        }
        PropertiesFile[] files = (PropertiesFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PropertiesFile[]>(){

            public PropertiesFile[] compute() {
                return GwtI18nManagerImpl.this.getPropertiesFiles(aClass);
            }
        });
        if (files.length == 0) {
            if (EMPTY_PROPERTIES_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "getProperties"));
            }
            return EMPTY_PROPERTIES_ARRAY;
        }
        String propertyName = GwtI18nUtil.getPropertyName(method);
        ArrayList<IProperty> properties = new ArrayList<IProperty>();
        for (PropertiesFile file : files) {
            IProperty property = file.findPropertyByKey(propertyName);
            if (property == null) continue;
            properties.add(property);
        }
        IProperty[] iPropertyArray = properties.toArray(new IProperty[properties.size()]);
        if (iPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "getProperties"));
        }
        return iPropertyArray;
    }

    @Override
    @Nullable
    public PsiMethod getMethod(@NotNull IProperty property) {
        PsiMethod[] psiMethods;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/gwt/i18n/GwtI18nManagerImpl", "getMethod"));
        }
        PsiClass psiClass = this.getPropertiesInterface(property.getPropertiesFile());
        if (psiClass == null) {
            return null;
        }
        String baseName = GwtI18nManagerImpl.getBaseName(property);
        for (PsiMethod psiMethod : psiMethods = psiClass.getMethods()) {
            String propertyName = GwtI18nUtil.getPropertyName(psiMethod);
            if (propertyName == null || !propertyName.equals(baseName)) continue;
            return psiMethod;
        }
        return null;
    }

    @Nullable
    private static String getBaseName(IProperty property) {
        String key = property.getUnescapedKey();
        if (key == null) {
            return null;
        }
        int i = key.indexOf(91);
        return i != -1 ? key.substring(0, i) : key;
    }
}

